package com.crawler.pay.wxpay;

/**
 * 微信支付配置
 * @author rubekid
 *
 * 2017年8月23日 下午7:03:54
 */
public class WxpayConfig {
	
	/**
	 * 微信APP ID
	 */
	private String appId;
	
	/**
	 * 微信商户 ID
	 */
	private String mchId;
	
	/**
	 * 微信证书路径
	 */
	private String certPath;
	
	/**
	 * 微信API密钥
	 */
	private String apiKey;
	
	/**
	 * 异步通知地址
	 */
	private String notifyUrl;
	
	/**
	 * 请求IP 地址
	 */
	private String ip;
	
	public WxpayConfig() {
	
	}
	
	/**
	 * 
	 * @param appId
	 * @param mchId
	 * @param apiKey
	 * @param certPath
	 * @param notifyUrl
	 */
	public WxpayConfig(String appId, String mchId, String apiKey, String certPath, String notifyUrl, String ip){
		this.appId = appId;
		this.mchId = mchId;
		this.certPath = certPath;
		this.apiKey = apiKey;
		this.notifyUrl = notifyUrl;
		this.ip = ip;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public String getMchId() {
		return mchId;
	}

	public void setMchId(String mchId) {
		this.mchId = mchId;
	}

	public String getCertPath() {
		return certPath;
	}

	public void setCertPath(String certPath) {
		this.certPath = certPath;
	}

	public String getApiKey() {
		return apiKey;
	}

	public void setApiKey(String apiKey) {
		this.apiKey = apiKey;
	}

	public String getNotifyUrl() {
		return notifyUrl;
	}

	public void setNotifyUrl(String notifyUrl) {
		this.notifyUrl = notifyUrl;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}
}
