package com.crawler.pay.wxpay.model;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 红包查询响应内容
 */
public class RedPackageQueryResult {

    /**
     * SENDING:发放中
     */
    public static final String STATUS_SENDING = "SENDING";

    /**
     * SENT:已发放待领取
     */
    public static final String STATUS_SENT = "SENT";


    /**
     * FAILED：发放失败
     */
    public static final String STATUS_FAILED = "FAILED";


    /**
     * RECEIVED:已领取
     */
    public static final String STATUS_RECEIVED = "RECEIVED";


    /**
     * RFUND_ING:退款中
     */
    public static final String STATUS_RFUND_ING = "RFUND_ING";


    /**
     * REFUND:已退款
     */
    public static final String STATUS_REFUND = "REFUND";


    /**
     * API:通过API接口发放
     * UPLOAD:通过上传文件方式发放
     * ACTIVITY:通过活动方式发放
     */
    public static final String SEND_TYPE_API = "API";


    /**
     * UPLOAD:通过上传文件方式发放
     */
    public static final String SEND_TYPE_UPLOAD = "UPLOAD";

    /**
     * ACTIVITY:通过活动方式发放
     */
    public static final String SEND_TYPE_ACTIVITY = "ACTIVITY";


    /**
     * GROUP:裂变红包
     */
    public static final String HB_TYPE_GROUP = "GROUP";

    /**
     * NORMAL:普通红包
     */
    public static final String HB_TYPE_NORMAL = "NORMAL";



    /**
     * 商户订单号
     */
    private String mchBillno;

    /**
     * 商户号
     */
    private String mchId;

    /**
     * 红包单号
     */
    private String detailId;

    /**
     * SENDING:发放中
     * SENT:已发放待领取
     * FAILED：发放失败
     * RECEIVED:已领取
     * RFUND_ING:退款中
     * REFUND:已退款
     * 红包状态
     */
    private String status;

    /**
     * 发放类型
     */
    private String sendType;

    /**
     * 红包类型
     */
    private String hbType;

    /**
     * 红包个数
     */
    private Integer totalNum;

    /**
     * 红包金额 单位元
     */
    private BigDecimal totalAmount;

    /**
     * 失败原因
     */
    private String reason;

    /**
     * 发送时间
     */
    private Date sendTime;

    /**
     * 红包退款时间
     */
    private Date refundTime;

    /**
     * 红包退款金额（元）
     */
    private BigDecimal refundAmount;

    /**
     * 祝福语
     */
    private String wishing;

    /**
     * 活动描述
     */
    private String  remark;

    /**
     * 活动名称
     */
    private String actName;

    /**
     * 红包列表
     */
    private List<Hbinfo> hblist;

    /**
     * 消息
     */
    private String message;

    public String getMchBillno() {
        return mchBillno;
    }

    public void setMchBillno(String mchBillno) {
        this.mchBillno = mchBillno;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getDetailId() {
        return detailId;
    }

    public void setDetailId(String detailId) {
        this.detailId = detailId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSendType() {
        return sendType;
    }

    public void setSendType(String sendType) {
        this.sendType = sendType;
    }

    public String getHbType() {
        return hbType;
    }

    public void setHbType(String hbType) {
        this.hbType = hbType;
    }

    public Integer getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Date getSendTime() {
        return sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public Date getRefundTime() {
        return refundTime;
    }

    public void setRefundTime(Date refundTime) {
        this.refundTime = refundTime;
    }

    public BigDecimal getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getWishing() {
        return wishing;
    }

    public void setWishing(String wishing) {
        this.wishing = wishing;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getActName() {
        return actName;
    }

    public void setActName(String actName) {
        this.actName = actName;
    }

    public List<Hbinfo> getHblist() {
        return hblist;
    }

    public void setHblist(List<Hbinfo> hblist) {
        this.hblist = hblist;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
