package com.crawler.pay.common;

import java.io.InputStream;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 支付配置
 * @author rubekid
 *
 * 2017年7月3日 下午10:04:09
 */
public class PayProperties {

	private static final Logger logger = LoggerFactory.getLogger(PayProperties.class);
    private static Properties properties;

    static {
        try {
            properties = new Properties();
            InputStream stream = PayProperties.class.getClassLoader().getResourceAsStream("pay.properties");
            if (stream != null) {
                properties.load(stream);
            }
        } catch (Exception ex) {
            logger.warn("Read pay.properties error.", ex);
        }
    }
    
    public static Properties getProperties() {
        return properties;
    }



    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static void setProperty(String key, String value) {
        properties.setProperty(key, value);
    }

    public static int getPropertyForInteger(String key) {
        String value = getProperty(key);
        try {
            return Integer.parseInt(value);
        } catch (Exception ex) {
            throw new IllegalArgumentException("转换 \"" + value + "\" 为 int 过程发生错误，引发的 properties 属性为 " + key);
        }
    }

    public static int getPropertyForInteger(String key, String defaultValue) {
        String value = getProperty(key, defaultValue);
        try {
            return Integer.parseInt(value);
        } catch (Exception ex) {
            throw new IllegalArgumentException("转换 \"" + value + "\" 为 int 过程发生错误，引发的 properties 属性为 " + key);
        }
    }
    
    public static boolean getPropertyForBoolean(String key, String defaultValue) {
        String value = getProperty(key, defaultValue);
        try {
            return Boolean.parseBoolean(value);
        } catch (Exception ex) {
            throw new IllegalArgumentException("转换 \"" + value + "\" 为 boolean 过程发生错误，引发的 properties 属性为 " + key);
        }
    }
    
    /**
     * APP ID
     */
    public static final String APP_ID = properties.getProperty("app.id");
    
    /**
     * APP SECRET
     */
    public static final String APP_SECRET = properties.getProperty("app.secret");
    
    

}
