/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.pay.alipay;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.crawler.pay.alipay.config.AlipayConfig;
import com.crawler.pay.common.OrderBase;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class AlipayUtils {
    public static final String ALIPAY_TRADE_QUERY = "https://openapi.alipay.com/gateway.do";

    public static String getOrderInfo(String notifyUrl, String orderNo, String subject, String detail, BigDecimal totalFee) {
        String orderInfo = "partner=\"" + AlipayConfig.PARTNER + "\"";
        orderInfo = String.valueOf(orderInfo) + "&seller_id=\"" + AlipayConfig.SELLER_EMAIL + "\"";
        orderInfo = String.valueOf(orderInfo) + "&out_trade_no=\"" + orderNo + "\"";
        orderInfo = String.valueOf(orderInfo) + "&subject=\"" + subject + "\"";
        orderInfo = String.valueOf(orderInfo) + "&body=\"" + detail + "\"";
        orderInfo = String.valueOf(orderInfo) + "&total_fee=\"" + totalFee + "\"";
        orderInfo = String.valueOf(orderInfo) + "&notify_url=\"" + notifyUrl + "\"";
        orderInfo = String.valueOf(orderInfo) + "&service=\"mobile.securitypay.pay\"";
        orderInfo = String.valueOf(orderInfo) + "&payment_type=\"1\"";
        orderInfo = String.valueOf(orderInfo) + "&_input_charset=\"utf-8\"";
        orderInfo = String.valueOf(orderInfo) + "&it_b_pay=\"30m\"";
        return orderInfo;
    }

    public static String unifiedOrder(OrderBase order, String notifyUrl) {
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(ALIPAY_TRADE_QUERY, AlipayConfig.APP_ID, AlipayConfig.APP_PRIVATE_KEY, "json", "utf-8", AlipayConfig.ALIPAY_PUBLIC_KEY, AlipayConfig.SIGN_TYPE);
        AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
        AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
        model.setBody(order.getDetail());
        model.setSubject(order.getTitle());
        model.setOutTradeNo(order.getOrderNo());
        model.setTimeoutExpress("30m");
        model.setTotalAmount(String.valueOf(order.getFee()));
        model.setProductCode("QUICK_MSECURITY_PAY");
        request.setBizModel((AlipayObject)model);
        request.setNotifyUrl(notifyUrl);
        try {
            AlipayTradeAppPayResponse response = (AlipayTradeAppPayResponse)alipayClient.sdkExecute((AlipayRequest)request);
            return response.getBody();
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean notifyCheck(HttpServletRequest request) throws AlipayApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            int i = 0;
            while (i < values.length) {
                valueStr = i == values.length - 1 ? String.valueOf(valueStr) + values[i] : String.valueOf(valueStr) + values[i] + ",";
                ++i;
            }
            params.put(name, valueStr);
        }
        return AlipaySignature.rsaCheckV1(params, (String)AlipayConfig.ALIPAY_PUBLIC_KEY, (String)"utf-8", (String)AlipayConfig.SIGN_TYPE);
    }

    public static boolean refund(String orderNo, String tradeNo, BigDecimal amount, String reason) throws AlipayApiException {
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(ALIPAY_TRADE_QUERY, AlipayConfig.APP_ID, AlipayConfig.APP_PRIVATE_KEY, "JSON", "utf-8");
        AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
        request.setBizContent("{    \"out_trade_no\":\"" + orderNo + "\"," + "    \"trade_no\":\"" + tradeNo + "\"," + "    \"refund_amount\":" + amount + "," + "    \"refund_reason\":\"" + reason + "\"" + "  }");
        AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)request);
        return response.isSuccess();
    }
}

