/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.pay.common;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayProperties {
    private static final Logger logger = LoggerFactory.getLogger(PayProperties.class);
    private static Properties properties;
    public static final String APP_ID;
    public static final String APP_SECRET;

    static {
        try {
            properties = new Properties();
            InputStream stream = PayProperties.class.getClassLoader().getResourceAsStream("pay.properties");
            if (stream != null) {
                properties.load(stream);
            }
        }
        catch (Exception ex) {
            logger.warn("Read pay.properties error.", (Throwable)ex);
        }
        APP_ID = properties.getProperty("app.id");
        APP_SECRET = properties.getProperty("app.secret");
    }

    public static Properties getProperties() {
        return properties;
    }

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static void setProperty(String key, String value) {
        properties.setProperty(key, value);
    }

    public static int getPropertyForInteger(String key) {
        String value = PayProperties.getProperty(key);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("\u8f6c\u6362 \"" + value + "\" \u4e3a int \u8fc7\u7a0b\u53d1\u751f\u9519\u8bef\uff0c\u5f15\u53d1\u7684 properties \u5c5e\u6027\u4e3a " + key);
        }
    }

    public static int getPropertyForInteger(String key, String defaultValue) {
        String value = PayProperties.getProperty(key, defaultValue);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("\u8f6c\u6362 \"" + value + "\" \u4e3a int \u8fc7\u7a0b\u53d1\u751f\u9519\u8bef\uff0c\u5f15\u53d1\u7684 properties \u5c5e\u6027\u4e3a " + key);
        }
    }

    public static boolean getPropertyForBoolean(String key, String defaultValue) {
        String value = PayProperties.getProperty(key, defaultValue);
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("\u8f6c\u6362 \"" + value + "\" \u4e3a boolean \u8fc7\u7a0b\u53d1\u751f\u9519\u8bef\uff0c\u5f15\u53d1\u7684 properties \u5c5e\u6027\u4e3a " + key);
        }
    }
}

