/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.pay.wxpay;

import com.crawler.pay.alipay.exception.PayException;
import com.crawler.pay.common.MD5;
import com.crawler.pay.common.StringUtils;
import com.crawler.pay.http.ClientCustomSSL;
import com.crawler.pay.http.HttpUtils;
import com.crawler.pay.wxpay.WxpayConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxpayUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WxpayUtils.class);
    public static final String WX_UNIFIED_ORDER = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    public static final String WX_ORDER_QUERY = "https://api.mch.weixin.qq.com/pay/orderquery";
    public static final String WX_REFUND = "https://api.mch.weixin.qq.com/secapi/pay/refund";

    public static String createSign(SortedMap<String, Object> parameters, String appKey) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = String.valueOf(entry.getValue());
            if ("sign".equalsIgnoreCase(key) || "key".equalsIgnoreCase(key) || StringUtils.isNullOrEmpty(value)) continue;
            sb.append(String.valueOf(key) + "=" + value + "&");
        }
        sb.append("key=" + appKey);
        return MD5.encode(sb.toString()).toUpperCase();
    }

    public static String toXml(SortedMap<String, Object> parameters) {
        StringBuffer sb = new StringBuffer();
        sb.append("<xml>");
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = String.valueOf(entry.getValue());
            if ("attach".equalsIgnoreCase(key) || "body".equalsIgnoreCase(key) || "sign".equalsIgnoreCase(key)) {
                sb.append("<" + key + ">" + "<![CDATA[" + value + "]]></" + key + ">");
                continue;
            }
            sb.append("<" + key + ">" + value + "</" + key + ">");
        }
        sb.append("</xml>");
        return sb.toString();
    }

    public static SortedMap<String, String> doXMLParse(String xml) throws JDOMException, IOException {
        if (xml == null) {
            return null;
        }
        if ((xml = xml.replaceFirst("encoding=\".*\"", "encoding=\"UTF-8\"")) == null || "".equals(xml)) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((InputStream)in);
        Element root = doc.getRootElement();
        List list = root.getChildren();
        for (Element e : list) {
            String key = e.getName();
            String value = "";
            List children = e.getChildren();
            value = children.isEmpty() ? e.getTextNormalize() : WxpayUtils.getChildrenText(children);
            map.put(key, value);
        }
        ((InputStream)in).close();
        return map;
    }

    public static String getChildrenText(List<Element> children) {
        StringBuffer sb = new StringBuffer();
        if (!children.isEmpty()) {
            for (Element e : children) {
                String name = e.getName();
                String value = e.getTextNormalize();
                List list = e.getChildren();
                sb.append("<" + name + ">");
                if (!list.isEmpty()) {
                    sb.append(WxpayUtils.getChildrenText(list));
                }
                sb.append(value);
                sb.append("</" + name + ">");
            }
        }
        return sb.toString();
    }

    public static String setXML(String return_code, String return_msg) {
        return "<xml><return_code><![CDATA[" + return_code + "]]></return_code><return_msg><![CDATA[" + return_msg + "]]></return_msg></xml>";
    }

    public static boolean checkSign(SortedMap<String, String> map, String appKey) {
        String wxsign = String.valueOf(map.get("sign"));
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String k = entry.getKey();
            String v = entry.getValue();
            if ("sign".equals(k) || v == null || "".equals(v)) continue;
            sb.append(String.valueOf(k) + "=" + v + "&");
        }
        String sign = MD5.encode(String.valueOf(sb.toString()) + "key=" + appKey).toLowerCase();
        return wxsign.equalsIgnoreCase(sign);
    }

    public static String nonceStr() {
        return MD5.encode(WxpayUtils.getTimestamp());
    }

    public static String successResponse() {
        TreeMap<String, Object> response = new TreeMap<String, Object>();
        response.put("return_code", "SUCCESS");
        response.put("return_msg", "OK");
        return WxpayUtils.toXml(response);
    }

    public static SortedMap<String, Object> wechatUnifiedOrder(String orderNo, String detail, BigDecimal totalFee, String openId, WxpayConfig wxpayConfig) throws JDOMException, IOException {
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put("appid", wxpayConfig.getAppId());
        parameters.put("mch_id", wxpayConfig.getMchId());
        if (openId != null) {
            parameters.put("openid", openId);
        }
        parameters.put("nonce_str", WxpayUtils.nonceStr());
        parameters.put("body", detail);
        parameters.put("out_trade_no", orderNo);
        parameters.put("total_fee", new Double(totalFee.doubleValue() * 100.0).intValue());
        parameters.put("spbill_create_ip", wxpayConfig.getIp());
        parameters.put("notify_url", wxpayConfig.getNotifyUrl());
        parameters.put("trade_type", "JSAPI");
        String sign = WxpayUtils.createSign(parameters, wxpayConfig.getAppKey());
        parameters.put("sign", sign);
        String requestXML = WxpayUtils.toXml(parameters);
        System.out.println("==================\u7edf\u4e00\u4e0b\u5355=========================");
        System.out.println(requestXML);
        System.out.println("==================\u7edf\u4e00\u4e0b\u5355=========================");
        String response = HttpUtils.httpsRequest(WX_UNIFIED_ORDER, "POST", requestXML);
        SortedMap<String, String> map = WxpayUtils.doXMLParse(response);
        TreeMap<String, Object> params = null;
        if (!"SUCCESS".equals(map.get("result_code"))) {
            LOGGER.error("\u7edf\u4e00\u4e0b\u5355\u5931\u8d25" + response);
            throw new PayException("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u5931\u8d25");
        }
        params = new TreeMap<String, Object>();
        params.put("appId", wxpayConfig.getAppId());
        params.put("timeStamp", WxpayUtils.getTimestamp());
        params.put("nonceStr", WxpayUtils.createSign(params, wxpayConfig.getAppKey()));
        params.put("package", "prepay_id=" + (String)map.get("prepay_id"));
        params.put("signType", "MD5");
        params.put("paySign", WxpayUtils.createSign(params, wxpayConfig.getAppKey()));
        return params;
    }

    public static SortedMap<String, Object> h5UnifiedOrder(String orderNo, String detail, BigDecimal totalFee, WxpayConfig wxpayConfig) throws JDOMException, IOException {
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put("appid", wxpayConfig.getAppId());
        parameters.put("mch_id", wxpayConfig.getMchId());
        parameters.put("nonce_str", WxpayUtils.nonceStr());
        parameters.put("body", detail);
        parameters.put("out_trade_no", orderNo);
        parameters.put("total_fee", new Double(totalFee.doubleValue() * 100.0).intValue());
        parameters.put("spbill_create_ip", wxpayConfig.getIp());
        parameters.put("notify_url", wxpayConfig.getNotifyUrl());
        parameters.put("trade_type", "MWEB");
        String sign = WxpayUtils.createSign(parameters, wxpayConfig.getAppKey());
        parameters.put("sign", sign);
        String requestXML = WxpayUtils.toXml(parameters);
        System.out.println("==================\u7edf\u4e00\u4e0b\u5355=========================");
        System.out.println(requestXML);
        System.out.println("==================\u7edf\u4e00\u4e0b\u5355=========================");
        String response = HttpUtils.httpsRequest(WX_UNIFIED_ORDER, "POST", requestXML);
        SortedMap<String, String> map = WxpayUtils.doXMLParse(response);
        TreeMap<String, Object> params = null;
        if (!"SUCCESS".equals(map.get("result_code"))) {
            LOGGER.error("\u7edf\u4e00\u4e0b\u5355\u5931\u8d25" + response);
            throw new PayException("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u5931\u8d25");
        }
        params = new TreeMap<String, Object>();
        params.put("appId", wxpayConfig.getAppId());
        params.put("timeStamp", WxpayUtils.getTimestamp());
        params.put("nonceStr", WxpayUtils.createSign(params, wxpayConfig.getAppKey()));
        params.put("package", "prepay_id=" + (String)map.get("prepay_id"));
        params.put("signType", "MD5");
        params.put("paySign", WxpayUtils.createSign(params, wxpayConfig.getAppKey()));
        params.put("mwebUrl", map.get("mweb_url"));
        return params;
    }

    public static SortedMap<String, Object> appUnifiedOrder(String orderNo, String detail, BigDecimal totalFee, WxpayConfig wxpayConfig) throws JDOMException, IOException {
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put("appid", wxpayConfig.getAppId());
        parameters.put("mch_id", wxpayConfig.getMchId());
        parameters.put("nonce_str", WxpayUtils.nonceStr());
        parameters.put("body", detail);
        parameters.put("out_trade_no", orderNo);
        parameters.put("total_fee", new Double(totalFee.doubleValue() * 100.0).intValue());
        parameters.put("spbill_create_ip", wxpayConfig.getIp());
        parameters.put("notify_url", wxpayConfig.getNotifyUrl());
        parameters.put("trade_type", "APP");
        String sign = WxpayUtils.createSign(parameters, wxpayConfig.getAppKey());
        parameters.put("sign", sign);
        String requestXML = WxpayUtils.toXml(parameters);
        String response = HttpUtils.httpsRequest(WX_UNIFIED_ORDER, "POST", requestXML);
        SortedMap<String, String> map = WxpayUtils.doXMLParse(response);
        TreeMap<String, Object> params = null;
        if (!"SUCCESS".equals(map.get("result_code"))) {
            LOGGER.error("AppKey:" + wxpayConfig.getAppKey());
            LOGGER.error("requestXML:" + requestXML);
            LOGGER.error("\u7edf\u4e00\u4e0b\u5355\u5931\u8d25" + response);
            throw new PayException("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u5931\u8d25");
        }
        params = new TreeMap<String, Object>();
        params.put("appid", wxpayConfig.getAppId());
        params.put("partnerid", wxpayConfig.getMchId());
        params.put("prepayid", map.get("prepay_id"));
        params.put("noncestr", WxpayUtils.createSign(params, wxpayConfig.getAppKey()));
        params.put("timestamp", WxpayUtils.getTimestamp());
        params.put("package", "Sign=WXPay");
        params.put("sign", WxpayUtils.createSign(params, wxpayConfig.getAppKey()));
        return params;
    }

    public static boolean refund(String orderNo, String tradeNo, String refundNo, BigDecimal fee, Long userId, WxpayConfig wxpayConfig) {
        return WxpayUtils.refund(wxpayConfig.getAppId(), wxpayConfig.getMchId(), wxpayConfig.getCertPath(), wxpayConfig.getAppKey(), orderNo, tradeNo, refundNo, fee, userId);
    }

    public static boolean refund(String orderNo, String tradeNo, String refundNo, BigDecimal fee, BigDecimal totalFee, Long userId, WxpayConfig wxpayConfig) {
        return WxpayUtils.refund(wxpayConfig.getAppId(), wxpayConfig.getMchId(), wxpayConfig.getCertPath(), wxpayConfig.getAppKey(), orderNo, tradeNo, refundNo, fee, totalFee, userId);
    }

    public static boolean refund(String appId, String mchId, String certPath, String apiKey, String orderNo, String tradeNo, String refundNo, BigDecimal fee, Long userId) {
        return WxpayUtils.refund(appId, mchId, certPath, apiKey, orderNo, tradeNo, refundNo, fee, null, userId);
    }

    public static boolean refund(String appId, String mchId, String certPath, String apiKey, String orderNo, String tradeNo, String refundNo, BigDecimal fee, BigDecimal totalFee, Long userId) {
        long value;
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put("appid", appId);
        parameters.put("mch_id", mchId);
        parameters.put("nonce_str", WxpayUtils.nonceStr());
        if (orderNo != null) {
            parameters.put("out_trade_no", orderNo);
        }
        long total = value = fee.multiply(BigDecimal.valueOf(100L)).longValue();
        if (totalFee != null) {
            total = totalFee.multiply(BigDecimal.valueOf(100L)).longValue();
        }
        parameters.put("out_refund_no", refundNo);
        parameters.put("total_fee", total);
        parameters.put("refund_fee", value);
        parameters.put("op_user_id", userId);
        parameters.put("transaction_id", tradeNo);
        String sign = WxpayUtils.createSign(parameters, apiKey);
        parameters.put("sign", sign);
        String requestXML = WxpayUtils.toXml(parameters);
        try {
            String response = ClientCustomSSL.doRefund(mchId, certPath, WX_REFUND, requestXML);
            System.out.println("=======================\u5fae\u4fe1\u9000\u6b3e======================");
            System.out.println(response);
            SortedMap<String, String> map = WxpayUtils.doXMLParse(response);
            return "SUCCESS".equals(map.get("return_code")) && "SUCCESS".equals(map.get("result_code"));
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | JDOMException e) {
            LOGGER.error("\u7edf\u4e00\u4e0b\u5355\u5931\u8d25" + e.getMessage());
            throw new PayException("\u5fae\u4fe1\u9000\u6b3e\u5931\u8d25");
        }
    }

    private static String getTimestamp() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }
}

