/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.redis.utils;

import com.crawler.redis.config.JacksonObjectMapper;
import com.crawler.redis.exception.SimpleRuntimeException;
import com.crawler.redis.vo.RedisPage;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisException;

public class RedisManager {
    private static Logger logger = LoggerFactory.getLogger(RedisManager.class);
    private static int WAIT_TIMEOUT_MSECS = 60000;
    private static int LOCK_EXPIRE_MSECS = 60000;
    private static JedisPool pool;
    private static int DB_INDEX;

    static {
        DB_INDEX = 0;
        try {
            Properties props = new Properties();
            props.load(RedisManager.class.getClassLoader().getResourceAsStream("redis.properties"));
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxTotal(Integer.valueOf(props.getProperty("redis.pool.maxTotal")).intValue());
            config.setMaxIdle(Integer.valueOf(props.getProperty("redis.pool.maxIdle")).intValue());
            config.setMaxWaitMillis(Long.valueOf(props.getProperty("redis.pool.maxWaitMillis")).longValue());
            config.setTestOnBorrow(Boolean.valueOf(props.getProperty("redis.pool.testOnBorrow")).booleanValue());
            config.setTestOnReturn(Boolean.valueOf(props.getProperty("redis.pool.testOnReturn")).booleanValue());
            config.setTestWhileIdle(Boolean.valueOf(props.getProperty("redis.pool.testWhileIdle")).booleanValue());
            String host = props.getProperty("redis.host");
            Integer port = Integer.valueOf(props.getProperty("redis.port"));
            Integer timeout = Integer.valueOf(props.getProperty("redis.timeout"));
            String password = props.getProperty("redis.password");
            DB_INDEX = Integer.valueOf(props.getProperty("redis.dbindex", "0"));
            StringBuilder sb = new StringBuilder();
            sb.append("---------------- REDIS CONFIG ------------");
            sb.append("\nHOST:").append(host);
            sb.append("\nPORT:").append(port);
            sb.append("\nPASSWORD:").append(password);
            sb.append("\nINDEX:").append(DB_INDEX);
            logger.info(sb.toString());
            pool = password != null ? new JedisPool((GenericObjectPoolConfig)config, host, port.intValue(), timeout.intValue(), password) : new JedisPool((GenericObjectPoolConfig)config, host, port.intValue(), timeout.intValue());
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public static Map<String, Object> getPoolInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxBorrowWaitTimeMillis", pool.getMaxBorrowWaitTimeMillis());
        map.put("meanBorrowWaitTimeMillis", pool.getMeanBorrowWaitTimeMillis());
        map.put("active", pool.getNumActive());
        map.put("idle", pool.getNumIdle());
        map.put("waiters", pool.getNumWaiters());
        return map;
    }

    public static int getDbIndex() {
        return DB_INDEX;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean lock(String lockKey, Integer waitTimeout) {
        jedis = null;
        try {
            jedis = RedisManager.getJedis();
            if (waitTimeout == null) {
                waitTimeout = RedisManager.WAIT_TIMEOUT_MSECS;
            }
            while (true) {
                time = System.currentTimeMillis() + (long)RedisManager.LOCK_EXPIRE_MSECS + 1L;
                expireAt = String.valueOf(time);
                if (jedis.setnx(lockKey, expireAt) == 1L) {
                    return true;
                }
                currentValue = jedis.get(lockKey);
                if (currentValue != null && Long.parseLong(currentValue) < System.currentTimeMillis() && (oldValue = jedis.getSet(lockKey, expireAt)) != null && oldValue.equals(currentValue)) {
                    return true;
                }
                waitTimeout = waitTimeout - 100;
                try {
                    if (waitTimeout >= 0) {
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException ex) {
                    RedisManager.logger.error(ex.getMessage(), (Throwable)ex);
                }
                break;
            }
        }
        finally {
            if (waitTimeout >= 0) ** continue;
            return false;
        }
    }

    public static boolean lock(String lockKey) {
        return RedisManager.lock(lockKey, null);
    }

    public static void unlock(String lockKey) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.del(lockKey);
        }
    }

    public static boolean tryLock(String lockKey, int seconds) {
        try (Jedis jedis = null;){
            boolean bool;
            jedis = RedisManager.getJedis();
            boolean bl = bool = jedis.setnx(lockKey, ".lock") == 1L;
            if (bool) {
                jedis.expire(lockKey, seconds);
            }
            boolean bl2 = bool;
            return bl2;
        }
    }

    public static boolean expire(String key, int seconds) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            boolean bl = jedis.expire(key, seconds) == 1L;
            return bl;
        }
    }

    public static boolean expireAt(String key, long timestamp) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            boolean bl = jedis.expireAt(key, timestamp) == 1L;
            return bl;
        }
    }

    public static long ttl(String key) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            long l = jedis.ttl(key);
            return l;
        }
    }

    public static boolean persist(String key) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            boolean bl = jedis.persist(key) == 1L;
            return bl;
        }
    }

    public static void batchDeleteByKey(String prefix) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            Set set = jedis.keys(String.valueOf(prefix) + "*");
            Iterator it = set.iterator();
            ArrayList<String> keys = new ArrayList<String>();
            while (it.hasNext()) {
                keys.add((String)it.next());
                if (keys.size() <= 0 || keys.size() % 100 != 0) continue;
                jedis.del(keys.toArray(new String[keys.size()]));
                keys.clear();
            }
            if (keys.size() > 0) {
                jedis.del(keys.toArray(new String[keys.size()]));
            }
        }
    }

    public static synchronized Jedis getJedis() {
        Jedis resource = null;
        try {
            if (pool != null) {
                resource = pool.getResource();
                resource.select(DB_INDEX);
            }
        }
        catch (RuntimeException ex) {
            if (resource != null) {
                logger.error("=========== Jedis \u83b7\u53d6 resource \u5931\u8d25 ============");
                resource.close();
            }
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (resource == null) {
            throw new NullPointerException("jedis is null, please check the redis server.");
        }
        return resource;
    }

    public static void close(Jedis jedis) {
        jedis.close();
    }

    public static String get(String key, String defaultValue) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            String value = jedis.get(key);
            String string = value == null ? defaultValue : value;
            return string;
        }
    }

    public static String get(String key) {
        try (Jedis jedis = null;){
            String value;
            jedis = RedisManager.getJedis();
            String string = value = jedis.get(key);
            return string;
        }
        return null;
    }

    public static void set(String key, String value) {
        try (Jedis jedis = null;){
            try {
                jedis = RedisManager.getJedis();
                jedis.set(key, value);
            }
            catch (JedisException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
    }

    public static void hset(String key, Object obj) {
        try (Jedis jedis = null;){
            try {
                jedis = RedisManager.getJedis();
                Map<String, String> hash = RedisManager.toMap(obj);
                jedis.hmset(key, hash);
            }
            catch (JedisException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
    }

    public static Long hset(String key, String field, String value) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            Long l = jedis.hset(key, field, value);
            return l;
        }
        return -1L;
    }

    public static void hset(String key, Object obj, int seconds) {
        try (Jedis jedis = null;){
            try {
                jedis = RedisManager.getJedis();
                Map<String, String> hash = RedisManager.toMap(obj);
                jedis.hmset(key, hash);
                jedis.expire(key, seconds);
            }
            catch (JedisException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
    }

    public static <T> T hget(String key, Class<T> clazz) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            Map hash = jedis.hgetAll(key);
            if (hash != null && hash.size() > 0) {
                T t = RedisManager.parse(RedisManager.toJSONString(hash), clazz);
                return t;
            }
        }
        return null;
    }

    public static void set(String key, Object data, int seconds) {
        String value = null;
        value = data instanceof String ? String.valueOf(data) : RedisManager.toJSONString(data);
        Jedis jedis = null;
        try {
            try {
                jedis = RedisManager.getJedis();
                jedis.setex(key, seconds, value);
            }
            catch (JedisException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                RedisManager.close(jedis);
            }
        }
        finally {
            RedisManager.close(jedis);
        }
    }

    public static <T> T get(String key, Class<T> clazz) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            String value = jedis.get(key);
            if (RedisManager.isNullOrEmpty(value)) {
                return null;
            }
            T t = RedisManager.parse(value, clazz);
            return t;
        }
        return null;
    }

    public static <T> T get(int index, String key, Class<T> clazz) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.select(index);
            String value = jedis.get(key);
            if (RedisManager.isNullOrEmpty(value)) {
                return null;
            }
            T t = RedisManager.parse(value, clazz);
            return t;
        }
        return null;
    }

    public static String get(int index, String key) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.select(index);
            String string = jedis.get(key);
            return string;
        }
    }

    public static <T> List<T> findList(String key, Class<T> clazz, String ... exceptKeys) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            List data = new ArrayList();
            if (key.contains("*")) {
                Set keys = jedis.keys(key);
                List<String> exceptKeyList = Arrays.asList(exceptKeys);
                for (String k : keys) {
                    if (exceptKeyList.contains(k)) continue;
                    data.addAll(jedis.lrange(k, 0L, -1L));
                }
            } else {
                data = jedis.lrange(key, 0L, -1L);
            }
            ArrayList<T> list = new ArrayList<T>();
            for (String string : data) {
                list.add(RedisManager.parse(string, clazz));
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
    }

    public static <T> List<T> findListLike(String prefix, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            Set keys = jedis.keys(String.valueOf(prefix) + "*");
            for (String key : keys) {
                String value = jedis.get(key);
                if (value == null || "".equals(value)) continue;
                list.add(RedisManager.parse(value, clazz));
            }
        }
        return list;
    }

    public static List<String> findList(String key) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            ArrayList<String> data = new ArrayList();
            ArrayList<String> arrayList = data = jedis.lrange(key, 0L, -1L);
            return arrayList;
        }
    }

    public static RedisPage<T> findPage(RedisPage<T> page, String key) {
        try (Jedis jedis = null;){
            int start = page.getFirst();
            int end = start + page.getPageSize();
            jedis = RedisManager.getJedis();
            List data = jedis.lrange(key, (long)start, (long)end);
            ArrayList<T> list = new ArrayList<T>();
            for (String string : data) {
                list.add(RedisManager.parse(string, T.class));
            }
            page.setItems(list);
            RedisPage<T> redisPage = page;
            return redisPage;
        }
    }

    public static void put(String key, Object data) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.set(key, RedisManager.toJSONString(data));
        }
    }

    public static <E> void setList(String key, List<E> list) {
        block5: {
            try (Jedis jedis = null;){
                jedis = RedisManager.getJedis();
                jedis.del(key);
                String[] strings = RedisManager.toStrings(list);
                if (strings.length > 0) {
                    jedis.rpush(key, strings);
                    break block5;
                }
                throw new SimpleRuntimeException("\u6570\u636e\u9519\u8bef");
            }
        }
    }

    public static void insert(String key, Object item) {
        RedisManager.rpush(key, item);
    }

    public static void append(String key, Object item) {
        RedisManager.rpush(key, item);
    }

    public static <E> void batchAppend(String key, List<E> items) {
        block6: {
            if (items.size() > 0) {
                try (Jedis jedis = null;){
                    jedis = RedisManager.getJedis();
                    String[] strings = RedisManager.toStrings(items);
                    if (strings.length > 0) {
                        jedis.rpush(key, strings);
                        break block6;
                    }
                    throw new SimpleRuntimeException("\u6570\u636e\u9519\u8bef");
                }
            }
        }
    }

    public static void rpush(String key, Object item) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.rpush(key, new String[]{RedisManager.toJSONString(item)});
        }
    }

    public static void lpush(String key, Object item) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.lpush(key, new String[]{RedisManager.toJSONString(item)});
        }
    }

    public static Set<String> keys(String pattern) {
        try (Jedis jedis = null;){
            Set keys;
            jedis = RedisManager.getJedis();
            Set set = keys = jedis.keys(pattern);
            return set;
        }
    }

    public static void set(String key, Object obj) {
        try (Jedis jedis = null;){
            try {
                jedis = RedisManager.getJedis();
                jedis.set(key, RedisManager.toJSONString(obj));
            }
            catch (JedisException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
    }

    public static void set(int index, String key, Object obj) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.select(index);
            jedis.set(key, RedisManager.toJSONString(obj));
        }
    }

    public static long incrBy(int index, String key, long value) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.select(index);
            long l = jedis.incrBy(key, value);
            return l;
        }
    }

    public static long incrBy(String key, long value) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            long l = jedis.incrBy(key, value);
            return l;
        }
    }

    public static long decrBy(int index, String key, long value) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.select(index);
            long l = jedis.decrBy(key, value);
            return l;
        }
    }

    public static long decrBy(String key, long value) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            long l = jedis.decrBy(key, value);
            return l;
        }
    }

    public static void incrByFloat(int index, String key, float value) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.select(index);
            jedis.incrByFloat(key, (double)value);
        }
    }

    public static void incrByFloat(String key, float value) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.incrByFloat(key, (double)value);
        }
    }

    public static long hincrBy(int index, String key, String field, long value) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.select(index);
            long l = jedis.hincrBy(key, field, value);
            return l;
        }
    }

    public static long hincrBy(String key, String field, long value) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            long l = jedis.hincrBy(key, field, value);
            return l;
        }
    }

    public static void lset(String key, int index, Object obj) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.lset(key, (long)index, RedisManager.toJSONString(obj));
        }
    }

    public static void remove(String key) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.del(key);
        }
    }

    public static void publish(String channel, Object obj) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            String data = RedisManager.toJSONString(obj);
            jedis.publish(channel, data);
            logger.info("\n================== \u53d1\u5e03\u6d88\u606f ========================\n{} {}\n================== \u53d1\u5e03\u6d88\u606f\u7ed3\u675f ========================", (Object)channel, (Object)data);
        }
    }

    public static void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.subscribe(jedisPubSub, channels);
        }
    }

    public static <T> T pop(String key, Class<T> clazz) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            String value = jedis.lpop(key);
            if (RedisManager.isNullOrEmpty(value)) {
                return null;
            }
            T t = RedisManager.parse(value, clazz);
            return t;
        }
    }

    public static String pop(String key) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            String string = jedis.lpop(key);
            return string;
        }
    }

    public static String rpop(String key) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            String string = jedis.rpop(key);
            return string;
        }
    }

    public static void sadd(String key, Object ... items) {
        block5: {
            try (Jedis jedis = null;){
                jedis = RedisManager.getJedis();
                String[] strings = RedisManager.toStrings(items);
                if (strings.length > 0) {
                    jedis.sadd(key, strings);
                    break block5;
                }
                throw new SimpleRuntimeException("\u6570\u636e\u9519\u8bef");
            }
        }
    }

    public static <E> void sadd(String key, List<E> list) {
        block5: {
            try (Jedis jedis = null;){
                jedis = RedisManager.getJedis();
                String[] strings = RedisManager.toStrings(list);
                if (strings.length > 0) {
                    jedis.sadd(key, strings);
                    break block5;
                }
                throw new SimpleRuntimeException("\u6570\u636e\u9519\u8bef");
            }
        }
    }

    public static boolean sismember(String key, Object item) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            boolean bl = jedis.sismember(key, RedisManager.toJSONString(item));
            return bl;
        }
    }

    public static <T> List<T> smembers(String key, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            Set data = jedis.smembers(key);
            for (String string : data) {
                list.add(RedisManager.parse(string, clazz));
            }
        }
        return list;
    }

    public static List<String> smembers(String key) {
        ArrayList<String> list = new ArrayList<String>();
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            Set data = jedis.smembers(key);
            for (String string : data) {
                list.add(string);
            }
        }
        return list;
    }

    public static Long scard(String key) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            Long l = jedis.scard(key);
            return l;
        }
    }

    public static void srem(String key, Object ... items) {
        block5: {
            try (Jedis jedis = null;){
                jedis = RedisManager.getJedis();
                String[] strings = RedisManager.toStrings(items);
                if (strings.length > 0) {
                    jedis.srem(key, strings);
                    break block5;
                }
                throw new SimpleRuntimeException("\u6570\u636e\u9519\u8bef");
            }
        }
    }

    public static <T> T spop(String key, Class<T> clazz) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            String value = jedis.spop(key);
            if (RedisManager.isNullOrEmpty(value)) {
                return null;
            }
            T t = RedisManager.parse(value, clazz);
            return t;
        }
    }

    public static String spop(String key) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            String string = jedis.spop(key);
            return string;
        }
    }

    public static void zadd(String key, Double score, Object item) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.zadd(key, score.doubleValue(), RedisManager.toJSONString(item));
        }
    }

    public static <T> List<T> zrangeByScore(String key, Double minScore, Double maxScore, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            Set data = jedis.zrangeByScore(key, minScore.doubleValue(), maxScore.doubleValue());
            for (String string : data) {
                list.add(RedisManager.parse(string, clazz));
            }
        }
        return list;
    }

    public static <T> List<T> zrange(String key, Long start, Long end, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            Set data = jedis.zrange(key, start.longValue(), end.longValue());
            for (String string : data) {
                list.add(RedisManager.parse(string, clazz));
            }
        }
        return list;
    }

    public static <T> List<T> zrevrangeByScore(String key, Double maxScore, Double minScore, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            Set data = jedis.zrevrangeByScore(key, maxScore.doubleValue(), minScore.doubleValue());
            for (String string : data) {
                list.add(RedisManager.parse(string, clazz));
            }
        }
        return list;
    }

    public static <T> List<T> zrevrange(String key, Long start, Long end, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            Set data = jedis.zrevrange(key, start.longValue(), end.longValue());
            for (String string : data) {
                list.add(RedisManager.parse(string, clazz));
            }
        }
        return list;
    }

    public static void zremrangeByScore(String key, Double minScore, Double maxScore) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.zremrangeByScore(key, minScore.doubleValue(), maxScore.doubleValue());
        }
    }

    public static void zremrangeByLex(String key, String min, String max) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.zremrangeByLex(key, min, max);
        }
    }

    public static void zremrangeByRank(String key, Long start, Long end) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            jedis.zremrangeByRank(key, start.longValue(), end.longValue());
        }
    }

    public static void zrem(String key, Object ... items) {
        block5: {
            try (Jedis jedis = null;){
                jedis = RedisManager.getJedis();
                String[] strings = RedisManager.toStrings(items);
                if (strings.length > 0) {
                    jedis.zrem(key, strings);
                    break block5;
                }
                throw new SimpleRuntimeException("\u6570\u636e\u9519\u8bef");
            }
        }
    }

    public static Long zcard(String key) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            Long l = jedis.zcard(key);
            return l;
        }
    }

    public static Long zrank(String key, Object member) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            Long l = jedis.zrank(key, RedisManager.toJSONString(member));
            return l;
        }
    }

    public static Double zscore(String key, Object member) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            Double d = jedis.zscore(key, RedisManager.toJSONString(member));
            return d;
        }
    }

    public static boolean exists(String key) {
        try (Jedis jedis = null;){
            jedis = RedisManager.getJedis();
            boolean bl = jedis.exists(key);
            return bl;
        }
    }

    public static String toJSONString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        JacksonObjectMapper objectMapper = new JacksonObjectMapper();
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return "";
        }
    }

    public static Map<String, String> toMap(Object object) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map objMap = new HashMap();
        objMap = object instanceof Map ? (Map)object : (!(object instanceof String) ? RedisManager.parse(RedisManager.toJSONString(object), Map.class) : RedisManager.parse((String)object, Map.class));
        for (Map.Entry entry : objMap.entrySet()) {
            Object obj = entry.getValue();
            String value = String.valueOf(entry.getValue());
            if (obj instanceof List) {
                value = RedisManager.toJSONString(obj);
            }
            map.put(String.valueOf(entry.getKey()), value);
        }
        return map;
    }

    public static <T> T parse(String value, Class<T> clazz) {
        if (clazz == null || clazz.equals(String.class)) {
            return (T)value;
        }
        JacksonObjectMapper objectMapper = new JacksonObjectMapper();
        try {
            return (T)objectMapper.readValue(value, clazz);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static final <E> String[] toStrings(List<E> list) {
        String[] items = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            items[i] = RedisManager.toJSONString(list.get(i));
            ++i;
        }
        return items;
    }

    public static final <E> String[] toStrings(E[] list) {
        String[] items = new String[list.length];
        int i = 0;
        while (i < list.length) {
            items[i] = RedisManager.toJSONString(list[i]);
            ++i;
        }
        return items;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || "".equals(string);
    }
}

