/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.redis.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;

public class RedisPage<T> {
    public static final int PAGE_SIZE = 10;
    private List<T> items = new ArrayList<T>();
    private long totalCount = 0L;
    protected int pageNo = 1;
    protected int pageSize = 1;

    public RedisPage() {
        this.setPageSize(10);
    }

    public RedisPage(Integer pageSize, Integer pageNo) {
        this.setPageSize(pageSize);
        this.setPageNo(pageNo);
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getTotalPages() {
        long count = this.totalCount / (long)this.pageSize;
        if (this.totalCount % (long)this.pageSize > 0L) {
            ++count;
        }
        return count;
    }

    @JsonIgnore
    public int getFirst() {
        int first = 0;
        if (this.pageNo > 0 && this.pageSize > 0) {
            first = (this.pageNo - 1) * this.pageSize;
        }
        return first;
    }
}

