package com.baidu.ueditor.upload;

import com.baidu.ueditor.define.State;
import com.crawler.res.qiniu.QiniuClient;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class Uploader {
	private HttpServletRequest request = null;
	private Map<String, Object> conf = null;
	private QiniuClient qiniuClient = null;

	public Uploader(HttpServletRequest request, Map<String, Object> conf) {
		this.request = request;
		this.conf = conf;
	}
	
	public Uploader(HttpServletRequest request, Map<String, Object> conf, QiniuClient qiniuClient) {
		this.request = request;
		this.conf = conf;
		this.qiniuClient = qiniuClient;
	}

	public final State doExec() {
		String filedName = (String) this.conf.get("fieldName");
		State state = null;

		if ("true".equals(this.conf.get("isBase64"))) {
			state = Base64Uploader.save(this.request.getParameter(filedName),
					this.conf, this.qiniuClient);
		} else {
			state = BinaryUploader.save(this.request, this.conf, this.qiniuClient);
		}

		return state;
	}
}
