/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import com.crawler.res.qiniu.QiniuClient;
import com.crawler.res.utils.QiNiuUtils;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;

public final class Base64Uploader {
    public static State save(String content, Map<String, Object> conf) {
        return Base64Uploader.save(content, conf, null);
    }

    public static State save(String content, Map<String, Object> conf, QiniuClient qiniuClient) {
        long maxSize;
        byte[] data = Base64Uploader.decode(content);
        if (!Base64Uploader.validSize(data, maxSize = ((Long)conf.get("maxSize")).longValue())) {
            return new BaseState(false, 1);
        }
        String suffix = FileType.getSuffix("JPG");
        try {
            String fileName = UUID.randomUUID() + suffix;
            String url = "";
            url = qiniuClient != null ? qiniuClient.upload(data, fileName) : QiNiuUtils.upload(data, fileName);
            BaseState storageState = new BaseState(true);
            if (storageState.isSuccess()) {
                storageState.putInfo("size", content.length());
                storageState.putInfo("title", (String)conf.get("filename"));
                storageState.putInfo("url", url);
                storageState.putInfo("type", suffix);
                storageState.putInfo("original", "");
            }
            return storageState;
        }
        catch (RuntimeException ex) {
            return new BaseState(false, 4);
        }
    }

    private static byte[] decode(String content) {
        return Base64.decodeBase64((String)content);
    }

    private static boolean validSize(byte[] data, long length) {
        return (long)data.length <= length;
    }
}

