/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.ffmpeg.bean;

public class Video {
    public static final int WIDTH = 320;
    public static final int HEIGHT = 240;
    public static final String DEFAULT_RESOLUTION = "320*240";
    public static final double RATE = 1.3333333333333333;
    public static final int MAX_SIZE = 0x100000;
    private long duration;
    private long bitRate;
    private String resolution;
    private int width = 320;
    private int height = 240;
    private String srcFile;
    private String destFile;
    private String type;
    private String videoFormat;
    private String audioFormat;
    private String frontCover;
    private int rotate;
    private String transpose;
    private boolean support;

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getBitRate() {
        return this.bitRate;
    }

    public void setBitRate(long bitRate) {
        this.bitRate = bitRate;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVideoFormat() {
        return this.videoFormat;
    }

    public void setVideoFormat(String videoFormat) {
        this.videoFormat = videoFormat;
    }

    public String getAudioFormat() {
        return this.audioFormat;
    }

    public void setAudioFormat(String audioFormat) {
        this.audioFormat = audioFormat;
    }

    public boolean isSupport() {
        return this.support;
    }

    public void setSupport(boolean support) {
        this.support = support;
    }

    public String getFrontCover() {
        return this.frontCover;
    }

    public void setFrontCover(String frontCover) {
        this.frontCover = frontCover;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getSrcFile() {
        return this.srcFile;
    }

    public void setSrcFile(String srcFile) {
        this.srcFile = srcFile;
    }

    public String getDestFile() {
        return this.destFile;
    }

    public void setDestFile(String destFile) {
        this.destFile = destFile;
    }

    public void setDestResolution() {
        String[] nums;
        this.width = 320;
        this.height = 240;
        String resolution = this.getResolution();
        if (resolution != null && (resolution.indexOf("x") > 0 || resolution.indexOf("*") > 0) && (nums = resolution.split("[x\\*]")).length == 2) {
            int sWidth = Integer.parseInt(nums[0].trim());
            int sHeight = Integer.parseInt(nums[1].trim());
            double sRate = (double)sWidth / (double)sHeight;
            this.width = sWidth;
            this.height = sHeight;
            if (sWidth >= sHeight) {
                if (sRate > 1.3333333333333333 && sWidth > 320) {
                    this.width = 320;
                    this.height = this.width * sHeight / sWidth;
                } else if (sRate <= 1.3333333333333333 && sHeight > 240) {
                    this.height = 240;
                    this.width = this.height * sWidth / sHeight;
                }
            } else if (1.0 / sRate > 1.3333333333333333 && sHeight > 320) {
                this.height = 320;
                this.width = this.height * sWidth / sHeight;
            } else if (1.0 / sRate <= 1.3333333333333333 && sWidth > 240) {
                this.width = 240;
                this.height = this.width * sHeight / sWidth;
            }
            if (this.width % 2 != 0) {
                ++this.width;
            }
            if (this.height % 2 != 0) {
                ++this.height;
            }
        }
        if (this.getRotate() == 90 || this.getRotate() == 270) {
            int tmp = this.width;
            this.width = this.height;
            this.height = tmp;
        }
    }

    public String getCoverResolution() {
        int coverHeight = this.height > 240 ? 240 : this.height;
        int coverWidth = coverHeight * this.getWidth() / this.getHeight();
        return String.valueOf(coverWidth) + "*" + coverHeight;
    }

    public String getDestResolution() {
        return String.valueOf(this.getWidth()) + "*" + this.getHeight();
    }

    public String getTranspose() {
        return this.transpose;
    }

    public void setTranspose(String transpose) {
        this.transpose = transpose;
    }

    public int getRotate() {
        return this.rotate;
    }

    public void setRotate(int rotate) {
        this.rotate = rotate;
        switch (rotate) {
            case 90: {
                this.setTranspose("transpose=1");
                break;
            }
            case 180: {
                this.setTranspose("transpose=2,transpose=2");
                break;
            }
            case 270: {
                this.setTranspose("transpose=2");
            }
        }
    }
}

