/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.ffmpeg.utils;

import com.crawler.ffmpeg.bean.Audio;
import com.crawler.ffmpeg.bean.Video;
import com.crawler.ffmpeg.exception.FFmpegException;
import com.crawler.ffmpeg.utils.StringUtils;
import com.crawler.res.common.ResProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FFMpegUtils {
    private static final String CONTEXT_PATH = ResProperties.getProperty("ffmpeg.context.path", "/data");
    private static String ffmpegUri;
    private static String mencoderUri;

    static {
        if (ffmpegUri == null) {
            Properties prop = System.getProperties();
            String os = prop.getProperty("os.name");
            if (os.toLowerCase().startsWith("win")) {
                ffmpegUri = String.valueOf(CONTEXT_PATH) + "/ffmpeg/windows/ffmpeg.exe";
                mencoderUri = String.valueOf(CONTEXT_PATH) + "/ffmpeg/windows/mencoder.exe";
            } else {
                ffmpegUri = String.valueOf(CONTEXT_PATH) + "/ffmpeg/linux/ffmpeg";
                mencoderUri = String.valueOf(CONTEXT_PATH) + "/ffmpeg/linux/mencoder";
            }
        }
    }

    private static String getFfmpegUri() {
        return ffmpegUri;
    }

    private static String getMencoderUri() {
        return mencoderUri;
    }

    public static Audio parseAudio(String filePath) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(FFMpegUtils.getFfmpegUri());
        cmd.add("-i");
        cmd.add(filePath);
        Audio audio = new Audio();
        String result = FFMpegUtils.exec(cmd);
        if (result == "") {
            throw new FFmpegException("\u89c6\u9891\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
        }
        Matcher matcherInput = Pattern.compile("Input #0, (.*?), from (.*?)").matcher(result);
        Matcher baseMatcher = Pattern.compile("Duration: (.*?),(.*?)bitrate: (\\d*) kb\\/s").matcher(result);
        Matcher audioMatcher = Pattern.compile("Audio: (\\w*)(.*?), (\\d*) Hz").matcher(result);
        if (matcherInput.find()) {
            audio.setType(matcherInput.group(1));
        }
        if (baseMatcher.find()) {
            audio.setDuration(FFMpegUtils.runtimeToSecond(baseMatcher.group(1)));
            audio.setBitRate(Long.parseLong(baseMatcher.group(3)));
        }
        if (audioMatcher.find()) {
            audio.setFormat(audioMatcher.group(1));
        }
        return audio;
    }

    public static Video parseVideo(String filePath) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(FFMpegUtils.getFfmpegUri());
        cmd.add("-i");
        cmd.add(filePath);
        Video video = new Video();
        video.setSrcFile(filePath);
        String result = FFMpegUtils.exec(cmd);
        if (result == "") {
            throw new FFmpegException("\u89c6\u9891\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
        }
        Matcher matcherInput = Pattern.compile("Input #0, (.*?), from (.*?)").matcher(result);
        Matcher baseMatcher = Pattern.compile("Duration: (.*?), start: (.*?), bitrate: (\\d*) kb\\/s").matcher(result);
        Matcher videoMatcher = Pattern.compile("Video: (\\w*)(.*?), (.*?), (.*?)[\\s\\S]*").matcher(result);
        Matcher audioMatcher = Pattern.compile("Audio: (\\w*)(.*?), (\\d*) Hz").matcher(result);
        Matcher rotateMatcher = Pattern.compile("rotate(\\s*):(\\s*)(\\d+)").matcher(result);
        if (matcherInput.find()) {
            video.setType(matcherInput.group(1));
        }
        if (baseMatcher.find()) {
            video.setDuration(FFMpegUtils.runtimeToSecond(baseMatcher.group(1)));
            video.setBitRate(Integer.parseInt(baseMatcher.group(3)));
        }
        if (rotateMatcher.find()) {
            int rotate = Integer.parseInt(rotateMatcher.group(3));
            video.setRotate((rotate + 360) % 360);
        }
        if (videoMatcher.find()) {
            String videoInfo = videoMatcher.group(0);
            Matcher m = Pattern.compile("([1-9]\\d*x[1-9]\\d*)").matcher(videoInfo);
            if (m.find()) {
                video.setResolution(m.group(0));
                video.setDestResolution();
            }
            if ((m = Pattern.compile("Unknown format").matcher(videoInfo)).find()) {
                video.setSupport(false);
            } else {
                video.setSupport(true);
            }
            video.setVideoFormat(videoMatcher.group(1));
        }
        if (audioMatcher.find()) {
            video.setAudioFormat(audioMatcher.group(1));
        }
        return video;
    }

    public static Process processAvi(String originFileUri, String fileSavePath) throws IOException, InterruptedException {
        ArrayList<String> commend = new ArrayList<String>();
        commend.add(FFMpegUtils.getMencoderUri());
        commend.add(originFileUri);
        commend.add("-ovc");
        commend.add("lavc");
        commend.add("-oac");
        commend.add("mp3lame");
        commend.add("-lavcopts");
        commend.add("acodec=mp3:abitrate=64");
        commend.add("-xvidencopts");
        commend.add("bitrate=600");
        commend.add("-vf");
        commend.add("scale=320:-3");
        commend.add("-of");
        commend.add("avi");
        commend.add("-o");
        commend.add(fileSavePath);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(commend);
        Process p = processBuilder.start();
        return p;
    }

    public static void makeScreenCut(String filePath, String imageSavePath, String screenSize, String transpose) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(FFMpegUtils.getFfmpegUri());
        cmd.add("-i");
        cmd.add(filePath);
        cmd.add("-y");
        cmd.add("-f");
        cmd.add("image2");
        cmd.add("-ss");
        cmd.add("1");
        cmd.add("-t");
        cmd.add("0.001");
        if (!StringUtils.isNullOrEmpty(transpose)) {
            cmd.add("-vf");
            cmd.add(transpose);
        }
        cmd.add("-s");
        cmd.add(screenSize);
        cmd.add(imageSavePath);
        FFMpegUtils.exec(cmd);
    }

    public static void audioTransfer(String filePath, String fileSavePath, int audioByte, int audioCollection) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(FFMpegUtils.getFfmpegUri());
        cmd.add("-i");
        cmd.add(filePath);
        cmd.add("-y");
        cmd.add("-ab");
        cmd.add(Integer.toString(audioByte));
        cmd.add("-ar");
        cmd.add(Integer.toString(audioCollection));
        cmd.add("-ac");
        cmd.add("1");
        cmd.add(fileSavePath);
        FFMpegUtils.exec(cmd);
    }

    public static String toLibxvid(String filePath) throws Exception {
        String ext = StringUtils.getExtension(filePath);
        String fileSavePath = filePath.replace("." + ext, ".tmp." + ext);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(FFMpegUtils.getFfmpegUri());
        cmd.add("-i");
        cmd.add(filePath);
        cmd.add("-y");
        cmd.add("-c:v");
        cmd.add("libxvid");
        cmd.add(fileSavePath);
        FFMpegUtils.exec(cmd);
        return fileSavePath;
    }

    public static void resize(String filePath, String savePath, String bitRate, String resolution) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(FFMpegUtils.getFfmpegUri());
        cmd.add("-i");
        cmd.add(filePath);
        cmd.add("-b:v");
        cmd.add(bitRate);
        cmd.add("-s");
        cmd.add(resolution);
        cmd.add(savePath);
        FFMpegUtils.exec(cmd);
    }

    public static void videoTransfer(String filePath, String savePath, String resolution, int audioByte, int audioCollection, double quality, String preset, double fps, String transpose) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(FFMpegUtils.getFfmpegUri());
        cmd.add("-i");
        cmd.add(filePath);
        cmd.add("-y");
        cmd.add("-ab");
        cmd.add(Integer.toString(audioByte));
        cmd.add("-ar");
        cmd.add(Integer.toString(audioCollection));
        cmd.add("-r");
        cmd.add(Double.toString(fps));
        cmd.add("-crf");
        cmd.add(Double.toString(quality));
        cmd.add("-preset");
        cmd.add(preset);
        cmd.add("-profile:v");
        cmd.add("baseline");
        if (!StringUtils.isNullOrEmpty(transpose)) {
            cmd.add("-vf");
            cmd.add(transpose);
            cmd.add("-metadata:s:v:0");
            cmd.add("rotate=0");
        }
        cmd.add("-s");
        cmd.add(resolution);
        cmd.add(savePath);
        FFMpegUtils.exec(cmd);
    }

    public static void videoTransfer(String filePath, String savePath, String resolution, String transpose) throws IOException, InterruptedException {
        FFMpegUtils.videoTransfer(filePath, savePath, resolution, 43000, 44100, 23.0, "medium", 15.0, transpose);
    }

    private static int runtimeToSecond(String str) {
        int second = 0;
        String[] s = str.split(":");
        if (s.length == 3) {
            second = Integer.parseInt(s[0]) * 60 * 60 + Integer.parseInt(s[1]) * 60 + (int)Math.abs(Double.parseDouble(s[2]));
        }
        return second;
    }

    private static String exec(List<String> cmd) throws IOException, InterruptedException {
        String line;
        String outPut = "";
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(cmd);
        builder.redirectErrorStream(true);
        Process proc = builder.start();
        BufferedReader stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        while ((line = stdout.readLine()) != null) {
            outPut = String.valueOf(outPut) + "\n" + line;
            System.out.println(line);
            line.indexOf("Error");
        }
        proc.waitFor();
        stdout.close();
        String lastLine = outPut.substring(outPut.lastIndexOf("\n") + 1);
        if (lastLine.indexOf("Error") == 0) {
            throw new RuntimeException(lastLine);
        }
        return outPut;
    }
}

