/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.res.common;

import com.crawler.ffmpeg.bean.Audio;
import com.crawler.ffmpeg.bean.Video;
import com.crawler.ffmpeg.utils.FFMpegUtils;
import com.crawler.res.common.FileType;
import com.crawler.res.common.ResConstant;
import com.crawler.res.image.Image;
import com.crawler.res.qiniu.QiniuClient;
import com.crawler.res.utils.FileUtils;
import com.crawler.res.utils.QiNiuUtils;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import javax.imageio.ImageIO;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public abstract class UploaderBaseController {
    @RequestMapping(value={"/token"}, method={RequestMethod.GET})
    public Object token() {
        String token = QiNiuUtils.getUpToken();
        JSONObject json = new JSONObject();
        json.put((Object)"value", (Object)token);
        return json;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public JSONObject upload(@RequestParam(value="file") CommonsMultipartFile multipartFile) throws IOException {
        return this.doFileUpload(multipartFile);
    }

    @ResponseBody
    @RequestMapping(value={"/files"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public JSONArray multiUpload(@RequestParam(value="files") List<CommonsMultipartFile> multipartFiles1, @RequestParam(value="files[]") List<CommonsMultipartFile> multipartFiles2) throws IOException {
        List<CommonsMultipartFile> multipartFiles = multipartFiles1 == null ? multipartFiles2 : multipartFiles1;
        JSONArray items = new JSONArray();
        for (CommonsMultipartFile multipartFile : multipartFiles) {
            items.add((Object)this.doFileUpload(multipartFile));
        }
        return items;
    }

    @ResponseBody
    @RequestMapping(value={"/image"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public JSONObject imageUpload(@RequestParam(value="image") CommonsMultipartFile multipartFile, @RequestParam(value="showInfo", required=false, defaultValue="false") Boolean showInfo, @RequestParam(value="width", required=false) Integer width, @RequestParam(value="height", required=false) Integer height) throws Exception {
        return this.doImageUpload(multipartFile, showInfo, width, height);
    }

    @ResponseBody
    @RequestMapping(value={"/images"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public JSONArray batchImageUpload(@RequestParam(value="images", required=false) List<CommonsMultipartFile> multipartFiles1, @RequestParam(value="images[]", required=false) List<CommonsMultipartFile> multipartFiles2, @RequestParam(value="showInfo", required=false, defaultValue="false") Boolean showInfo, @RequestParam(value="width", required=false) Integer width, @RequestParam(value="height", required=false) Integer height) throws Exception {
        List<CommonsMultipartFile> multipartFiles = multipartFiles1 == null ? multipartFiles2 : multipartFiles1;
        JSONArray items = new JSONArray();
        for (CommonsMultipartFile multipartFile : multipartFiles) {
            items.add((Object)this.doImageUpload(multipartFile, showInfo, width, height));
        }
        return items;
    }

    @ResponseBody
    @RequestMapping(value={"/audio"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public JSONObject audioUpload(@RequestParam(value="audio") CommonsMultipartFile multipartFile) throws IOException {
        return this.doFileUpload(multipartFile, ".mp3");
    }

    @ResponseBody
    @RequestMapping(value={"/video"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public JSONObject videoUpload(@RequestParam(value="video") CommonsMultipartFile multipartFile, @RequestParam(value="privately", defaultValue="false") Boolean privately, @RequestParam(value="forceResize", defaultValue="false") Boolean forceResize, @RequestParam(value="resolution", defaultValue="640x360") String resolution) throws IOException {
        String oFileName = multipartFile.getOriginalFilename();
        String ext = ".mp4";
        if (oFileName.contains(".")) {
            ext = oFileName.substring(oFileName.lastIndexOf(".")).toLowerCase();
        }
        String baseFileName = FileUtils.createFileName();
        String fileName = String.valueOf(baseFileName) + ext;
        String newFileName = String.valueOf(baseFileName) + ".mp4";
        JSONObject result = new JSONObject();
        if (!newFileName.equals(fileName) || forceResize.booleanValue()) {
            fileName = "tmp/" + fileName;
            String url = QiNiuUtils.uploadVideo(multipartFile.getBytes(), fileName);
            String persistentId = QiNiuUtils.toMp4(fileName, newFileName, resolution);
            result.put((Object)"persistentId", (Object)persistentId);
            result.put((Object)"url", (Object)url);
            result.put((Object)"preview", (Object)(privately != false ? QiNiuUtils.getPrivateDownloadUrl(url) : url));
            return result;
        }
        String url = QiNiuUtils.uploadVideo(multipartFile.getBytes(), newFileName);
        JSONObject info = QiNiuUtils.avinfo(url);
        result.put((Object)"url", (Object)url);
        result.put((Object)"preview", (Object)(privately != false ? QiNiuUtils.getPrivateDownloadUrl(url) : url));
        result.put((Object)"cover", (Object)QiNiuUtils.getVideoCover(url, info.getInt("width"), info.getInt("height")));
        result.put((Object)"size", info.get("size"));
        result.put((Object)"width", info.get("width"));
        result.put((Object)"height", info.get("height"));
        result.put((Object)"duration", info.get("duration"));
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/m3u8"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public JSONObject m3u8(@RequestParam(value="video") CommonsMultipartFile multipartFile, @RequestParam(value="privately", defaultValue="false") Boolean privately, @RequestParam(value="forceResize", defaultValue="false") Boolean forceResize) throws IOException, InterruptedException {
        String srcFilePath;
        String oFileName = multipartFile.getOriginalFilename();
        String ext = ".tmp";
        if (oFileName.contains(".")) {
            ext = oFileName.substring(oFileName.lastIndexOf(".")).toLowerCase();
        }
        String baseFileName = FileUtils.createFileName();
        String fileName = "video/mp4/" + baseFileName + ".mp4";
        JSONObject result = new JSONObject();
        String url = "";
        if (!".mp4".equalsIgnoreCase(ext)) {
            srcFilePath = String.valueOf(ResConstant.TEMP_PATH) + baseFileName + ext;
            String destFilePath = String.valueOf(ResConstant.TEMP_PATH) + baseFileName + ".mp4";
            File srcFile = new File(srcFilePath);
            if (!srcFile.exists()) {
                srcFile.createNewFile();
            }
            multipartFile.transferTo(srcFile);
            Video video = FFMpegUtils.parseVideo(srcFilePath);
            FFMpegUtils.videoTransfer(srcFilePath, destFilePath, video.getDestResolution(), video.getTranspose());
            File destFile = new File(destFilePath);
            url = QiNiuUtils.uploadVideo(destFilePath, fileName);
            srcFile.delete();
            destFile.delete();
        } else if (forceResize.booleanValue()) {
            srcFilePath = String.valueOf(ResConstant.TEMP_PATH) + baseFileName + ext;
            String destFilePath = String.valueOf(ResConstant.TEMP_PATH) + baseFileName + "_resize.mp4";
            File srcFile = new File(srcFilePath);
            if (!srcFile.exists()) {
                srcFile.createNewFile();
            }
            multipartFile.transferTo(srcFile);
            Video video = FFMpegUtils.parseVideo(srcFilePath);
            if (video.getBitRate() > 900L) {
                FFMpegUtils.resize(srcFilePath, destFilePath, "800k", video.getDestResolution());
                File destFile = new File(destFilePath);
                url = QiNiuUtils.uploadVideo(destFilePath, fileName);
                srcFile.delete();
                destFile.delete();
            } else {
                url = QiNiuUtils.uploadVideo(multipartFile.getBytes(), fileName);
            }
        } else {
            url = QiNiuUtils.uploadVideo(multipartFile.getBytes(), fileName);
        }
        String persistentId = QiNiuUtils.m3u8(fileName);
        result.put((Object)"persistentId", (Object)persistentId);
        result.put((Object)"url", (Object)url);
        result.put((Object)"preview", (Object)(privately != false ? QiNiuUtils.getPrivateDownloadUrl(url) : url));
        result.put((Object)"m3u8", (Object)QiNiuUtils.getM3u8FullPath(fileName));
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/cover"}, method={RequestMethod.GET})
    public JSONObject getCover(@RequestParam(value="url") String url, @RequestParam(value="width") Integer width, @RequestParam(value="height") Integer height) {
        JSONObject response = new JSONObject();
        response.put((Object)"cover", (Object)QiNiuUtils.uploadVideoCover(url, width, height));
        return response;
    }

    @ResponseBody
    @RequestMapping(value={"/video/query/status/{persistentId:.+}"}, method={RequestMethod.GET})
    public JSONObject queryVideoStatus(@PathVariable(value="persistentId") String persistentId) throws QiniuException {
        Client client = new Client();
        return JSONObject.fromObject((Object)client.get("http://api.qiniu.com/status/get/prefop?id=" + persistentId).bodyString());
    }

    @ResponseBody
    @RequestMapping(value={"/download"}, method={RequestMethod.GET})
    public JSONObject download(@RequestParam(value="url") String baseUrl, @RequestParam(value="expires") Long expires) throws QiniuException {
        JSONObject json = new JSONObject();
        json.put((Object)"url", (Object)QiNiuUtils.getPrivateDownloadUrl(baseUrl, expires));
        return json;
    }

    @ResponseBody
    @RequestMapping(value={"/local"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public JSONObject uploadLocal(@RequestParam(value="file") CommonsMultipartFile multipartFile, @RequestParam(value="privately", defaultValue="false") Boolean privately, @RequestParam(value="fileType", defaultValue="file") FileType fileType) throws IOException, InterruptedException {
        return this.doLocalUpload(multipartFile, fileType);
    }

    @ResponseBody
    @RequestMapping(value={"/certification"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public JSONObject uploadCertification(@RequestParam(value="image") CommonsMultipartFile multipartFile) throws IOException, InterruptedException {
        return this.doLocalUpload(multipartFile, FileType.image, false, true, ResConstant.WATERMARK_CERTIFICATION);
    }

    @ResponseBody
    @RequestMapping(value={"/temp"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public JSONObject uploadTemp(@RequestParam(value="file") CommonsMultipartFile multipartFile, @RequestParam(value="privately", defaultValue="false") Boolean privately, @RequestParam(value="fileType", defaultValue="file") FileType fileType) throws IOException, InterruptedException {
        return this.doTempUpload(multipartFile, fileType);
    }

    @ResponseBody
    @RequestMapping(value={"/locals"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public JSONArray multiUploadLocal(@RequestParam(value="files", required=false) List<CommonsMultipartFile> multipartFiles1, @RequestParam(value="files[]", required=false) List<CommonsMultipartFile> multipartFiles2, @RequestParam(value="fileType", defaultValue="file") FileType fileType) throws IOException {
        List<CommonsMultipartFile> multipartFiles = multipartFiles1 == null ? multipartFiles2 : multipartFiles1;
        JSONArray items = new JSONArray();
        for (CommonsMultipartFile multipartFile : multipartFiles) {
            items.add((Object)this.doLocalUpload(multipartFile, fileType));
        }
        return items;
    }

    @ResponseBody
    @RequestMapping(value={"/temps"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public JSONArray multiUploadTemp(@RequestParam(value="files", required=false) List<CommonsMultipartFile> multipartFiles1, @RequestParam(value="files[]", required=false) List<CommonsMultipartFile> multipartFiles2, @RequestParam(value="fileType", defaultValue="file") FileType fileType) throws IOException {
        List<CommonsMultipartFile> multipartFiles = multipartFiles1 == null ? multipartFiles2 : multipartFiles1;
        JSONArray items = new JSONArray();
        for (CommonsMultipartFile multipartFile : multipartFiles) {
            items.add((Object)this.doTempUpload(multipartFile, fileType));
        }
        return items;
    }

    protected JSONObject doImageUpload(CommonsMultipartFile multipartFile, Boolean showInfo, Integer width, Integer height) throws Exception {
        byte[] bytes;
        if (width == null) {
            width = ResConstant.MAX_WIDTH;
        }
        if (height == null) {
            height = 0;
        }
        Image image = new Image(multipartFile);
        if (width > 0) {
            ByteArrayOutputStream outputStream = image.resize(width, 0, ResConstant.LIMIT_SIZE);
            image.removeTemp();
            bytes = outputStream.toByteArray();
        } else {
            bytes = multipartFile.getBytes();
        }
        JSONObject result = new JSONObject();
        if (ResConstant.IS_QINIU_MODE.booleanValue()) {
            QiniuClient client = this.getQiniuClient();
            String url = "";
            url = client != null ? client.upload(bytes, image.getFullName()) : QiNiuUtils.upload(bytes, image.getFullName());
            result.put((Object)"url", (Object)url);
            if (showInfo != null && showInfo.booleanValue()) {
                JSONObject info = QiNiuUtils.imageInfo(url);
                result.put((Object)"size", info.get("size"));
                result.put((Object)"width", info.get("width"));
                result.put((Object)"height", info.get("height"));
            }
        } else {
            String filePath = String.valueOf(ResConstant.FILE_SERVER_PATH) + File.separator + image.getFullName();
            String url = String.valueOf(ResConstant.FILE_SERVER_DOMAIN) + "/" + image.getFullName().replaceAll(Matcher.quoteReplacement(File.separator), "/");
            File distFile = new File(filePath);
            FileUtils.bytes2File(bytes, distFile);
            result.put((Object)"url", (Object)url);
            if (showInfo != null && showInfo.booleanValue()) {
                BufferedImage bufferedImage = ImageIO.read(distFile);
                result.put((Object)"size", (Object)distFile.length());
                result.put((Object)"width", (Object)bufferedImage.getWidth());
                result.put((Object)"height", (Object)bufferedImage.getHeight());
            }
        }
        return result;
    }

    protected JSONObject doLocalUpload(CommonsMultipartFile multipartFile) {
        return this.doLocalUpload(multipartFile, null, false, false);
    }

    protected JSONObject doLocalUpload(CommonsMultipartFile multipartFile, FileType fileType) {
        boolean extra = false;
        if (FileType.audio.equals((Object)fileType) || FileType.video.equals((Object)fileType)) {
            extra = true;
        }
        return this.doLocalUpload(multipartFile, fileType, extra, false);
    }

    protected JSONObject doTempUpload(CommonsMultipartFile multipartFile, FileType fileType) {
        boolean extra = false;
        if (FileType.audio.equals((Object)fileType) || FileType.video.equals((Object)fileType)) {
            extra = true;
        }
        return this.doLocalUpload(multipartFile, fileType, extra, true);
    }

    protected JSONObject doLocalUpload(CommonsMultipartFile multipartFile, FileType fileType, boolean extra, boolean temp) {
        return this.doLocalUpload(multipartFile, fileType, extra, temp, null);
    }

    protected JSONObject doLocalUpload(CommonsMultipartFile multipartFile, FileType fileType, boolean extra, boolean temp, String watermark) {
        String oFileName = multipartFile.getOriginalFilename();
        String ext = this.getExt(oFileName, fileType);
        String fileName = String.valueOf(FileUtils.createFileName()) + ext;
        String dateDir = this.getDateDir();
        String subfix = String.valueOf(dateDir) + File.separator + (Object)((Object)fileType);
        if (temp) {
            subfix = String.valueOf(ResConstant.FILE_SERVER_TEMP_DIR) + File.separator + subfix;
        }
        JSONObject result = new JSONObject();
        String url = "";
        if (!multipartFile.isEmpty()) {
            String storePath = String.valueOf(ResConstant.FILE_SERVER_PATH) + File.separator + subfix;
            File filepath = new File(storePath, fileName);
            if (!filepath.getParentFile().exists()) {
                filepath.getParentFile().mkdirs();
            }
            try {
                File distFile = new File(String.valueOf(storePath) + File.separator + fileName);
                multipartFile.transferTo(distFile);
                if (fileType.equals((Object)FileType.image) && watermark != null && !"".equals(watermark) && ResConstant.WATERMARK_CERTIFICATION.equals(watermark)) {
                    FileUtils.watermark(distFile, new File(watermark));
                }
                url = String.valueOf(ResConstant.FILE_SERVER_DOMAIN) + "/" + subfix.replaceAll(Matcher.quoteReplacement(File.separator), "/") + "/" + fileName;
                if (extra) {
                    if (FileType.audio.equals((Object)fileType)) {
                        Audio audio = FFMpegUtils.parseAudio(String.valueOf(storePath) + File.separator + fileName);
                        result.putAll((Map)JSONObject.fromObject((Object)audio));
                    } else if (FileType.video.equals((Object)fileType)) {
                        String fullPath = String.valueOf(storePath) + File.separator + fileName;
                        Video video = FFMpegUtils.parseVideo(fullPath);
                        FFMpegUtils.makeScreenCut(fullPath, String.valueOf(fullPath) + ".jpg", video.getResolution(), null);
                        result.putAll((Map)JSONObject.fromObject((Object)video));
                        result.put((Object)"cover", (Object)(String.valueOf(url) + ".jpg"));
                        result.remove("srcFile");
                        result.remove("destFile");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        result.put((Object)"url", (Object)url);
        result.put((Object)"preview", (Object)url);
        return result;
    }

    protected JSONObject doFileUpload(CommonsMultipartFile multipartFile, String ext) throws IOException {
        String oFileName;
        if (ext == null) {
            ext = ".tmp";
        }
        if ((oFileName = multipartFile.getOriginalFilename()).contains(".")) {
            ext = oFileName.substring(oFileName.lastIndexOf(".")).toLowerCase();
        }
        String fileName = UUID.randomUUID() + ext;
        byte[] bytes = multipartFile.getBytes();
        QiniuClient client = this.getQiniuClient();
        String url = "";
        url = client != null ? client.upload(bytes, fileName) : QiNiuUtils.upload(bytes, fileName);
        JSONObject result = new JSONObject();
        result.put((Object)"url", (Object)url);
        return result;
    }

    protected JSONObject doFileUpload(CommonsMultipartFile multipartFile) throws IOException {
        return this.doFileUpload(multipartFile, ".tmp");
    }

    protected String getExt(String fileName, FileType fileType) {
        if (fileName.contains(".")) {
            return fileName.substring(fileName.lastIndexOf(".")).toLowerCase();
        }
        if (FileType.image.equals((Object)fileType)) {
            return ".jpg";
        }
        if (FileType.audio.equals((Object)fileType)) {
            return ".mp3";
        }
        if (FileType.video.equals((Object)fileType)) {
            return ".mp4";
        }
        return ".tmp";
    }

    protected String getDateDir() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String dateDir = df.format(new Date());
        return dateDir;
    }

    protected QiniuClient getQiniuClient() {
        return null;
    }
}

