/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.res.image;

import com.crawler.res.common.ResConstant;
import com.crawler.res.image.ImageScale;
import com.crawler.res.utils.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class Image {
    public static final int THUMB_WIDTH = 200;
    public static final int THUMB_HEIGHT = 200;
    private FileInputStream srcStream;
    private File srcFile;
    private String fileName;
    private String mimeType;
    private long size;
    private String type;

    public Image(CommonsMultipartFile multipartFile) throws Exception {
        this.mimeType = FileUtils.getMimeType(multipartFile);
        this.type = ImageScale.getType(this.mimeType);
        this.fileName = FileUtils.createFileName();
        this.srcFile = new File(String.valueOf(ResConstant.TEMP_PATH) + this.getFullName());
        if (!this.srcFile.exists()) {
            this.srcFile.createNewFile();
        }
        multipartFile.transferTo(this.srcFile);
        this.srcStream = new FileInputStream(this.srcFile);
    }

    public ByteArrayOutputStream resize(int maxWidth, int maxHeight, int sizeLimit) throws IOException {
        if ("jpg".equals(this.type)) {
            ByteArrayOutputStream outStream = ImageScale.toOutputStream(this.srcStream);
            float quality = 0.8f;
            do {
                outStream = ImageScale.resize(this.srcFile, maxWidth, maxHeight, this.type, quality);
                quality = (float)((double)quality - 0.1);
            } while (sizeLimit > 0 && outStream.size() > sizeLimit && (double)quality > 0.4);
            return outStream;
        }
        return ImageScale.resize(this.srcFile, maxWidth, maxHeight, this.type);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFullName() {
        return String.valueOf(this.fileName) + "." + this.type;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void removeTemp() {
        if (this.srcFile.exists()) {
            this.srcFile.delete();
        }
    }
}

