/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.res.image;

import com.crawler.res.utils.FileUtils;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.summercool.image.AnimatedGifEncoder;
import org.summercool.image.GifDecoder;
import org.summercool.image.Scalr;

public class ImageScale {
    public static final String TYPE_JPEG = "jpg";
    public static final String TYPE_PNG = "png";
    public static final String TYPE_GIF = "gif";
    public static final String TYPE_BMP = "bmp";

    public static void resize(File srcFile, File destFile, int maxWidth, int maxHeight, String type, float quality) throws IOException {
        if (TYPE_GIF.equals(type)) {
            ImageScale.resizeGif(srcFile, destFile, maxWidth, maxHeight);
        } else if (TYPE_PNG.equals(type)) {
            ImageScale.resizePng(srcFile, destFile, maxWidth, maxHeight);
        } else {
            ImageScale.resizeJpeg(srcFile, destFile, maxWidth, maxHeight, quality);
        }
    }

    public static void resize(File srcFile, File destFile, int maxWidth, int maxHeight, String type) throws IOException {
        ImageScale.resize(srcFile, destFile, maxWidth, maxHeight, type, 0.8f);
    }

    public static void resize(File srcFile, File destFile, int maxWidth, int maxHeight, float quality) throws Exception {
        ImageScale.resize(srcFile, destFile, maxWidth, maxHeight, ImageScale.getType(srcFile), quality);
    }

    public static void resize(File srcFile, File destFile, int maxWidth, int maxHeight) throws Exception {
        ImageScale.resize(srcFile, destFile, maxWidth, maxHeight, ImageScale.getType(srcFile));
    }

    public static void resizeJpeg(File srcFile, File destFile, int maxWidth, int maxHeight, float quality) throws IOException {
        BufferedImage image = ImageIO.read(srcFile);
        double rate = ImageScale.getResizeRate(srcFile, maxWidth, maxHeight);
        int width = (int)((double)image.getWidth() * rate);
        int height = (int)((double)image.getHeight() * rate);
        image = Scalr.resize((BufferedImage)image, (Scalr.Method)Scalr.Method.AUTOMATIC, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setComposite(AlphaComposite.getInstance(10, 1.0f));
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.drawImage((Image)image, 0, 0, null);
        image = bufferedImage;
        FileOutputStream out = new FileOutputStream(destFile);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
        param.setQuality(quality, false);
        encoder.setJPEGEncodeParam(param);
        encoder.encode(image);
    }

    public static void resizePng(File srcFile, File destFile, int maxWidth, int maxHeight) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(srcFile);
        double rate = ImageScale.getResizeRate(srcFile, maxWidth, maxHeight);
        if (rate == 1.0) {
            FileUtils.copy(srcFile, destFile);
        } else {
            int width = (int)((double)bufferedImage.getWidth() * rate);
            int height = (int)((double)bufferedImage.getHeight() * rate);
            BufferedImage result = Scalr.resize((BufferedImage)bufferedImage, (Scalr.Method)Scalr.Method.AUTOMATIC, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
            ImageIO.write((RenderedImage)result, TYPE_PNG, destFile);
        }
    }

    public static void resizeGif(File srcFile, File destFile, int maxWidth, int maxHeight) throws IOException {
        GifDecoder gd = new GifDecoder();
        int status = gd.read((InputStream)new FileInputStream(srcFile));
        if (status != 0) {
            return;
        }
        double rate = ImageScale.getResizeRate(srcFile, maxWidth, maxHeight);
        if (rate == 1.0) {
            FileUtils.copy(srcFile, destFile);
        } else {
            AnimatedGifEncoder ge = new AnimatedGifEncoder();
            ge.start((OutputStream)new FileOutputStream(destFile));
            ge.setRepeat(0);
            int i = 0;
            while (i < gd.getFrameCount()) {
                BufferedImage frame = gd.getFrame(i);
                int width = frame.getWidth();
                int height = frame.getHeight();
                width = (int)((double)width * rate);
                height = (int)((double)height * rate);
                BufferedImage rescaled = Scalr.resize((BufferedImage)frame, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
                int delay = gd.getDelay(i);
                ge.setDelay(delay);
                ge.addFrame(rescaled);
                ++i;
            }
            ge.finish();
        }
    }

    public static ByteArrayOutputStream resizeJpeg(File srcFile, int maxWidth, int maxHeight, float quality) throws IOException {
        BufferedImage image = ImageIO.read(srcFile);
        double rate = ImageScale.getResizeRate(srcFile, maxWidth, maxHeight);
        int width = (int)((double)image.getWidth() * rate);
        int height = (int)((double)image.getHeight() * rate);
        image = Scalr.resize((BufferedImage)image, (Scalr.Method)Scalr.Method.AUTOMATIC, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setComposite(AlphaComposite.getInstance(10, 1.0f));
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.drawImage((Image)image, 0, 0, null);
        image = bufferedImage;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
        param.setQuality(quality, false);
        encoder.setJPEGEncodeParam(param);
        encoder.encode(image);
        return out;
    }

    public static ByteArrayOutputStream resizePng(File srcFile, int maxWidth, int maxHeight) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(srcFile);
        double rate = ImageScale.getResizeRate(srcFile, maxWidth, maxHeight);
        if (rate == 1.0) {
            FileInputStream inputStream = new FileInputStream(srcFile);
            return ImageScale.toOutputStream(inputStream);
        }
        int width = (int)((double)bufferedImage.getWidth() * rate);
        int height = (int)((double)bufferedImage.getHeight() * rate);
        BufferedImage result = Scalr.resize((BufferedImage)bufferedImage, (Scalr.Method)Scalr.Method.AUTOMATIC, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)result, TYPE_PNG, out);
        return out;
    }

    public static ByteArrayOutputStream resizeGif(File srcFile, int maxWidth, int maxHeight) throws IOException {
        GifDecoder gd = new GifDecoder();
        int status = gd.read((InputStream)new FileInputStream(srcFile));
        if (status != 0) {
            return ImageScale.toOutputStream(new FileInputStream(srcFile));
        }
        double rate = ImageScale.getResizeRate(srcFile, maxWidth, maxHeight);
        if (rate == 1.0) {
            return ImageScale.toOutputStream(new FileInputStream(srcFile));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AnimatedGifEncoder ge = new AnimatedGifEncoder();
        ge.start((OutputStream)out);
        ge.setRepeat(0);
        int i = 0;
        while (i < gd.getFrameCount()) {
            BufferedImage frame = gd.getFrame(i);
            int width = frame.getWidth();
            int height = frame.getHeight();
            width = (int)((double)width * rate);
            height = (int)((double)height * rate);
            BufferedImage rescaled = Scalr.resize((BufferedImage)frame, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
            int delay = gd.getDelay(i);
            ge.setDelay(delay);
            ge.addFrame(rescaled);
            ++i;
        }
        ge.finish();
        return out;
    }

    public static double getResizeRate(File srcFile, int maxWidth, int maxHeight) throws IOException {
        double rate = 1.0;
        if (maxWidth == 0 && maxHeight == 0) {
            return rate;
        }
        BufferedImage bImage = ImageIO.read(srcFile);
        int width = bImage.getWidth();
        int height = bImage.getHeight();
        if (maxWidth == 0 && height > maxHeight) {
            rate = (double)maxHeight / (double)height;
        } else if (maxHeight == 0 && width > maxWidth) {
            rate = (double)maxWidth / (double)width;
        } else if ((width > maxWidth || height > maxHeight) && maxWidth > 0 && maxHeight > 0) {
            double d = rate = (double)maxWidth / (double)width > (double)maxHeight / (double)height ? (double)maxHeight / (double)height : (double)maxWidth / (double)width;
        }
        if (rate > 1.0) {
            rate = 1.0;
        }
        return rate;
    }

    public static String getType(File file) throws Exception {
        String mimeType = FileUtils.getMimeType(file);
        return ImageScale.getType(mimeType);
    }

    public static ByteArrayOutputStream resize(File srcFile, int maxWidth, int maxHeight, String type, float quality) throws IOException {
        if (TYPE_GIF.equals(type)) {
            return ImageScale.resizeGif(srcFile, maxWidth, maxHeight);
        }
        if (TYPE_PNG.equals(type)) {
            return ImageScale.resizePng(srcFile, maxWidth, maxHeight);
        }
        return ImageScale.resizeJpeg(srcFile, maxWidth, maxHeight, quality);
    }

    public static ByteArrayOutputStream resize(File srcFile, int maxWidth, int maxHeight, String type) throws IOException {
        return ImageScale.resize(srcFile, maxWidth, maxHeight, type, 0.8f);
    }

    public static ByteArrayOutputStream toOutputStream(InputStream inputStream) throws IOException {
        int ch;
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        while ((ch = inputStream.read()) != -1) {
            swapStream.write(ch);
        }
        return swapStream;
    }

    public static String getType(String mimeType) {
        if ("image/gif".equals(mimeType)) {
            return TYPE_GIF;
        }
        if ("image/png".equals(mimeType) || "image/x-png".equals(mimeType)) {
            return TYPE_PNG;
        }
        if ("image/bmp".equals(mimeType) || "image/x-ms-bmp".equals(mimeType)) {
            return TYPE_BMP;
        }
        return TYPE_JPEG;
    }
}

