/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.res.qiniu;

import com.crawler.res.qiniu.QiniuConfig;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QiniuClient {
    private final Logger logger = LoggerFactory.getLogger(QiniuClient.class);
    private String domain;
    private String bucketName;
    private Auth auth;
    private Configuration cfg;
    private String token;

    public QiniuClient() {
    }

    public QiniuClient(String domain, String accessKey, String secretKey, String bucketName, String zone) {
        this.domain = domain;
        this.bucketName = bucketName;
        this.auth = Auth.create((String)accessKey, (String)secretKey);
        this.cfg = new Configuration(this.getZone(zone));
        this.token = this.getUpToken(bucketName);
    }

    public QiniuClient(QiniuConfig config) {
        this.domain = config.getDomain();
        this.bucketName = config.getBucketName();
        this.auth = Auth.create((String)config.getAccessKey(), (String)config.getSecretKey());
        this.cfg = new Configuration(this.getZone(config.getZone()));
        this.token = this.getUpToken(this.bucketName);
    }

    public QiniuClient(String domain, String token, String bucketName, String zone) {
        this.domain = domain;
        this.bucketName = bucketName;
        this.cfg = new Configuration(this.getZone(zone));
        this.token = token;
    }

    public Zone getZone(String value) {
        Zone zone = Zone.autoZone();
        if ("zone0".equals(value)) {
            zone = Zone.zone0();
        } else if ("zone1".equals(value)) {
            zone = Zone.zone1();
        } else if ("zone2".equals(value)) {
            zone = Zone.zone2();
        } else if ("zoneNa0".equals(value)) {
            zone = Zone.zoneNa0();
        }
        return zone;
    }

    public String getUpToken() {
        return this.auth.uploadToken(this.bucketName, null, 360000L, null, true);
    }

    public String getUpToken(String bucketName) {
        return this.auth.uploadToken(bucketName, null, 360000L, null, true);
    }

    public String upload(byte[] data, String fileName) {
        try {
            UploadManager uploadManager = new UploadManager(this.cfg);
            Response res = uploadManager.put(data, fileName, this.token);
            this.logger.info("\u4e0a\u4f20\u54cd\u5e94\u4fe1\u606f\uff1a" + res.bodyString());
            return String.valueOf(this.domain) + "/" + fileName;
        }
        catch (QiniuException e) {
            this.logger.error(e.getMessage());
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    public String upload(String bucket, String filePath, String fileName) {
        try {
            System.out.println(this.cfg);
            UploadManager uploadManager = new UploadManager(this.cfg);
            Response res = uploadManager.put(filePath, fileName, this.getUpToken(bucket));
            this.logger.info("\u4e0a\u4f20\u54cd\u5e94\u4fe1\u606f\uff1a" + res.bodyString());
            return String.valueOf(this.domain) + "/" + fileName;
        }
        catch (QiniuException e) {
            this.logger.error(e.getMessage());
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    public String upload(String filePath, String fileName) {
        return this.upload(this.bucketName, filePath, fileName);
    }

    public String uploadVideoCover(String url, int width, int height, int offset) {
        String cover = String.format("%s?vframe/jpg/offset/%d/w/%d/h/%d", url, offset, width, height);
        String fileName = UUID.randomUUID() + ".jpg";
        return this.transfer(cover, fileName);
    }

    public String uploadVideoCover(String url, int width, int height) {
        return this.uploadVideoCover(url, width, height, 1);
    }

    public String getVideoCover(String url, int width, int height, int offset) {
        return String.format("%s?vframe/jpg/offset/%d/w/%d/h/%d", url, offset, width, height);
    }

    public String getVideoCover(String url, int width, int height) {
        return this.getVideoCover(url, width, height, 1);
    }

    public String transfer(String url, String fileName) {
        byte[] types;
        if (fileName == null) {
            fileName = UUID.randomUUID() + url.substring(url.lastIndexOf("."));
        }
        if ((types = this.toByte(url)) == null) {
            return null;
        }
        this.upload(types, fileName);
        return String.valueOf(this.domain) + "/" + fileName;
    }

    public String transfer(String url) {
        return this.transfer(url, null);
    }

    private byte[] toByte(String urlString) {
        try {
            URL url = new URL(urlString);
            URLConnection con = url.openConnection();
            con.setConnectTimeout(5000);
            InputStream is = con.getInputStream();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = is.read(buffer))) {
                output.write(buffer, 0, n);
            }
            is.close();
            return output.toByteArray();
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

