/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.res.utils;

import com.crawler.ffmpeg.bean.Video;
import com.crawler.ffmpeg.utils.FFMpegUtils;
import com.crawler.res.bean.FileBaseInfo;
import com.crawler.res.common.FileType;
import com.crawler.res.common.ResConstant;
import com.crawler.res.exception.ResException;
import com.crawler.res.utils.QiNiuUtils;
import eu.medsea.mimeutil.MimeUtil;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import javax.imageio.ImageIO;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class FileUtils {
    private static Logger logger = LoggerFactory.getLogger(FileUtils.class);

    static {
        MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.MagicMimeMimeDetector");
    }

    public static String createFileName() {
        String md5 = FileUtils.md5(UUID.randomUUID().toString(), System.currentTimeMillis());
        return md5.substring(8, 24);
    }

    public static String shortMd5(String message, String salt) {
        String md5 = FileUtils.md5(message, salt);
        return md5.substring(8, 24);
    }

    public static String md5(String message, Object salt) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            if (salt != null && !"".equals(salt)) {
                message = String.valueOf(message) + "{" + salt.toString() + "}";
            }
            byte[] digest = messageDigest.digest(message.getBytes("utf-8"));
            return Hex.encodeHexString((byte[])digest);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException exception) {
            return String.valueOf(System.currentTimeMillis());
        }
    }

    public static String syncToQiniuAndDelete(String url) {
        return FileUtils.syncToQiniu(url, null, false, true);
    }

    public static String syncToQiniu(String url) {
        return FileUtils.syncToQiniu(url, null, false, false);
    }

    public static String syncToQiniu(String url, boolean compressed, boolean remove) {
        return FileUtils.syncToQiniu(url, null, compressed, remove);
    }

    public static String save(String tempUrl) {
        String url = tempUrl;
        if (FileUtils.isTemp(tempUrl)) {
            String srcFilePath = FileUtils.getLocalPath(tempUrl);
            String destFilePath = tempUrl.replace(String.valueOf(ResConstant.FILE_SERVER_DOMAIN) + "/" + ResConstant.FILE_SERVER_TEMP_DIR, ResConstant.FILE_SERVER_PATH).replaceAll("/", Matcher.quoteReplacement(File.separator));
            FileUtils.move(srcFilePath, destFilePath);
            url = tempUrl.replace(String.valueOf(ResConstant.FILE_SERVER_DOMAIN) + "/" + ResConstant.FILE_SERVER_TEMP_DIR, ResConstant.FILE_SERVER_DOMAIN);
        }
        return url;
    }

    public static String syncToQiniu(String url, FileType fileType, boolean compressed, boolean remove) {
        try {
            String srcFilePath;
            File srcFile;
            String fileName = url.substring(url.lastIndexOf("/") + 1);
            if (!url.startsWith(ResConstant.FILE_SERVER_DOMAIN)) {
                return url;
            }
            String ext = "";
            if (fileName.contains(".")) {
                ext = fileName.substring(fileName.lastIndexOf("."));
            }
            if (!(srcFile = new File(srcFilePath = FileUtils.getLocalPath(url))).exists()) {
                return url;
            }
            if (fileType == null) {
                fileType = FileUtils.getFileType(srcFile);
            }
            String qiniuFileName = url.replace(String.valueOf(ResConstant.FILE_SERVER_DOMAIN) + "/", "");
            if (FileType.video.equals((Object)fileType)) {
                String baseFileName = fileName.substring(0, fileName.lastIndexOf("."));
                if (!".mp4".equals(ext)) {
                    String destFilePath = String.valueOf(ResConstant.TEMP_PATH) + baseFileName + ".mp4";
                    Video video = FFMpegUtils.parseVideo(srcFilePath);
                    FFMpegUtils.videoTransfer(srcFilePath, destFilePath, video.getDestResolution(), video.getTranspose());
                    File destFile = new File(destFilePath);
                    url = QiNiuUtils.uploadVideo(destFilePath, qiniuFileName);
                    destFile.delete();
                } else if (compressed) {
                    String destFilePath = String.valueOf(ResConstant.TEMP_PATH) + baseFileName + "_min.mp4";
                    Video video = FFMpegUtils.parseVideo(srcFilePath);
                    if (video.getBitRate() > 900L) {
                        FFMpegUtils.resize(srcFilePath, destFilePath, "800k", video.getDestResolution());
                        File destFile = new File(destFilePath);
                        url = QiNiuUtils.uploadVideo(destFilePath, qiniuFileName);
                        destFile.delete();
                    } else {
                        url = QiNiuUtils.uploadVideo(srcFilePath, qiniuFileName);
                    }
                } else {
                    url = QiNiuUtils.uploadVideo(srcFilePath, qiniuFileName);
                }
            } else {
                url = QiNiuUtils.upload(srcFilePath, qiniuFileName);
            }
            if (remove) {
                srcFile.delete();
            }
        }
        catch (IOException | InterruptedException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return url;
    }

    public static JSONObject imageInfo(String url) {
        if (FileUtils.isLoacl(url)) {
            JSONObject info = new JSONObject();
            try {
                String srcFilePath = FileUtils.getLocalPath(url);
                File file = new File(srcFilePath);
                if (file.exists()) {
                    BufferedImage image = ImageIO.read(new FileInputStream(file));
                    info.put((Object)"width", (Object)image.getWidth());
                    info.put((Object)"height", (Object)image.getHeight());
                    info.put((Object)"size", (Object)file.length());
                }
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            return info;
        }
        return QiNiuUtils.imageInfo(url);
    }

    public static JSONObject avinfo(String url) {
        if (FileUtils.isLoacl(url)) {
            JSONObject info = new JSONObject();
            try {
                String srcFilePath = FileUtils.getLocalPath(url);
                File file = new File(srcFilePath);
                if (file.exists()) {
                    Video video = FFMpegUtils.parseVideo(srcFilePath);
                    info.putAll((Map)JSONObject.fromObject((Object)video));
                    info.remove("srcFile");
                    info.remove("destFile");
                    info.put((Object)"size", (Object)file.length());
                }
            }
            catch (IOException | InterruptedException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            return info;
        }
        return QiNiuUtils.avinfo(url);
    }

    public static String getVideoCover(String url, int width, int height) {
        if (FileUtils.isLoacl(url)) {
            try {
                String srcFilePath = FileUtils.getLocalPath(url);
                File file = new File(srcFilePath);
                if (file.exists()) {
                    Video video = FFMpegUtils.parseVideo(srcFilePath);
                    String extName = String.valueOf(FileUtils.createFileName().substring(0, 3)) + ".jpg";
                    FFMpegUtils.makeScreenCut(srcFilePath, String.valueOf(srcFilePath.substring(0, srcFilePath.length() - 7)) + extName, video.getResolution(), null);
                    return String.valueOf(url.substring(0, url.length() - 7)) + extName;
                }
            }
            catch (IOException | InterruptedException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            return "";
        }
        return QiNiuUtils.getVideoCover(url, width, height);
    }

    public static boolean isLoacl(String url) {
        return url.startsWith(ResConstant.FILE_SERVER_DOMAIN);
    }

    public static boolean isTemp(String url) {
        return url.startsWith(String.valueOf(ResConstant.FILE_SERVER_DOMAIN) + "/" + ResConstant.FILE_SERVER_TEMP_DIR + "/");
    }

    public static String getLocalPath(String url) {
        return url.replace(ResConstant.FILE_SERVER_DOMAIN, ResConstant.FILE_SERVER_PATH).replaceAll("/", Matcher.quoteReplacement(File.separator));
    }

    public static String getLocalPath(String url, boolean forceDownload) {
        if (!FileUtils.isLoacl(url)) {
            try {
                url = FileUtils.syncToLocal(url);
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new ResException("\u7f51\u7edc\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25");
            }
        }
        return FileUtils.getLocalPath(url);
    }

    public static File getLocalFile(String url) {
        String path = FileUtils.getLocalPath(url);
        File file = new File(path);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static String getMimeType(File file) {
        Collection mimeTypes = MimeUtil.getMimeTypes((File)file);
        return mimeTypes.toString();
    }

    public static String getMimeType(CommonsMultipartFile file) {
        Collection mimeTypes = MimeUtil.getMimeTypes((byte[])file.getBytes());
        return mimeTypes.toString();
    }

    public static FileType getFileType(File file) {
        String mimeType = FileUtils.getMimeType(file);
        if (mimeType != null) {
            if (mimeType.startsWith("video")) {
                return FileType.video;
            }
            if (mimeType.startsWith("audio")) {
                return FileType.audio;
            }
            if (mimeType.startsWith("image")) {
                return FileType.image;
            }
        }
        return FileType.file;
    }

    public static void copy(File srcFile, File destFile) {
        try {
            org.apache.commons.io.FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new ResException("\u6587\u4ef6\u590d\u5236\u5931\u8d25");
        }
    }

    public static void move(String srcFilePath, String destFilePath) {
        File srcFile = new File(srcFilePath);
        File destFile = new File(destFilePath);
        if (!srcFile.exists()) {
            throw new ResException("\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        try {
            org.apache.commons.io.FileUtils.moveFile((File)srcFile, (File)destFile);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new ResException("\u6587\u4ef6\u590d\u5236\u5931\u8d25");
        }
    }

    public static byte[] urlToByte(String spec) {
        try {
            URL url = new URL(spec);
            URLConnection con = url.openConnection();
            con.setConnectTimeout(10000);
            InputStream is = con.getInputStream();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int n = 0;
            while (-1 != (n = is.read(buffer))) {
                output.write(buffer, 0, n);
            }
            is.close();
            return output.toByteArray();
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String syncToLocal(String spec) throws IOException {
        String fileName = spec.substring(spec.lastIndexOf("/") + 1);
        if (!spec.startsWith(ResConstant.FILE_SERVER_DOMAIN)) {
            return spec;
        }
        String ext = "";
        if (fileName.contains(".")) {
            ext = fileName.substring(fileName.lastIndexOf("."));
        }
        fileName = String.valueOf(FileUtils.createFileName()) + ext;
        String dateDir = FileUtils.getDateDir();
        String subfix = String.valueOf(dateDir) + File.separator + "download";
        String storePath = String.valueOf(ResConstant.FILE_SERVER_PATH) + File.separator + subfix;
        File filepath = new File(storePath, fileName);
        if (!filepath.getParentFile().exists()) {
            filepath.getParentFile().mkdirs();
        }
        URL url = new URL(spec);
        URLConnection con = url.openConnection();
        FileOutputStream out = new FileOutputStream(filepath);
        InputStream ins = con.getInputStream();
        byte[] b = new byte[1024];
        int i = 0;
        while ((i = ins.read(b)) != -1) {
            out.write(b, 0, i);
        }
        ins.close();
        out.close();
        return String.valueOf(ResConstant.FILE_SERVER_DOMAIN) + "/" + subfix.replaceAll(Matcher.quoteReplacement(File.separator), "/") + "/" + fileName;
    }

    public static String getDateDir() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String dateDir = df.format(new Date());
        return dateDir;
    }

    public static String toBase64(String path) {
        FileInputStream inputStream = null;
        byte[] data = null;
        try {
            inputStream = new FileInputStream(path);
            data = new byte[((InputStream)inputStream).available()];
            ((InputStream)inputStream).read(data);
            ((InputStream)inputStream).close();
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return Base64.encodeBase64String((byte[])data);
    }

    public static void watermark(File imageFile, File watermak) throws IOException {
        if (watermak.exists()) {
            BufferedImage bufferedImage = ImageIO.read(imageFile);
            Graphics2D gs = bufferedImage.createGraphics();
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            BufferedImage watermakImage = ImageIO.read(watermak);
            float rate = ResConstant.WATERMARK_RATE;
            int lw = (int)((float)width * rate);
            int lh = watermakImage.getHeight() * lw / watermakImage.getWidth();
            int wx = (width - lw) / 2;
            int wy = (height - lh) / 2;
            gs.setComposite(AlphaComposite.getInstance(10, 1.0f));
            gs.drawImage(watermakImage, wx, wy, lw, lh, null);
            gs.dispose();
            FileOutputStream os = new FileOutputStream(imageFile);
            ImageIO.write((RenderedImage)bufferedImage, "JPEG", os);
        }
    }

    public static void bytes2File(byte[] bytes, File distFile) throws IOException {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            if (!distFile.getParentFile().exists()) {
                distFile.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(distFile);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static FileBaseInfo getFileInfo(String fileName) {
        String filePath;
        String fileDirPath;
        File fileDir;
        String separator = File.separator;
        String url = String.valueOf(ResConstant.FILE_SERVER_DOMAIN) + "/" + fileName;
        if ("\\".equals(separator)) {
            fileName = fileName.replaceAll("/", "\\\\");
        }
        if (!(fileDir = new File(fileDirPath = (filePath = String.valueOf(ResConstant.FILE_SERVER_PATH) + separator + fileName).substring(0, filePath.lastIndexOf(separator)))).exists()) {
            fileDir.mkdirs();
        }
        FileBaseInfo info = new FileBaseInfo();
        info.setPath(filePath);
        info.setUrl(url);
        return info;
    }

    public static String getAbsolutePath(String dirName) {
        return String.valueOf(ResConstant.FILE_SERVER_PATH) + File.separator + dirName;
    }

    public static void deleteDirectory(File dir) {
        if (dir == null) {
            return;
        }
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            File[] files;
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                FileUtils.deleteDirectory(file);
                ++n2;
            }
            dir.delete();
        } else if (dir.isFile()) {
            dir.delete();
        }
    }
}

