/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.res.utils;

import com.crawler.res.image.AnimatedGifEncoder;
import com.crawler.res.image.GifDecoder;
import com.crawler.res.image.Scalr;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class ImageUtils {
    static Font FONT = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 18);
    static final Color COLOR = Color.WHITE;
    static final Color FONT_COLOR = new Color(255, 255, 255, 150);
    static final Color FONT_SHADOW_COLOR = new Color(170, 170, 170, 77);
    private static Map<Font, Map<String, int[]>> FONT_REC_MAP = new HashMap<Font, Map<String, int[]>>();

    public static boolean isJpg(String str) {
        return ImageUtils.isEndWid(str, "jpg");
    }

    public static boolean isPng(String str) {
        return ImageUtils.isEndWid(str, "png");
    }

    public static boolean isGif(String str) {
        return ImageUtils.isEndWid(str, "gif");
    }

    private static boolean isEndWid(String str, String ext) {
        if (str == null || "".equals(str.trim())) {
            return false;
        }
        int position = str.lastIndexOf(".");
        if (position == -1 || position == str.length() - 1) {
            return false;
        }
        String suffix = str.substring(position + 1);
        return ext.equalsIgnoreCase(suffix);
    }

    public static boolean isJpg(InputStream in) throws IOException {
        InputStream iis = in;
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Input stream must support mark");
        }
        iis.mark(30);
        try {
            int byte1 = iis.read();
            int byte2 = iis.read();
            if (byte1 == 255 && byte2 == 216) {
                return true;
            }
        }
        finally {
            iis.reset();
        }
        return false;
    }

    public static boolean isPng(InputStream in) throws IOException {
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Input stream must support mark");
        }
        byte[] b = new byte[8];
        try {
            in.mark(30);
            in.read(b);
        }
        finally {
            in.reset();
        }
        return b[0] == -119 && b[1] == 80 && b[2] == 78 && b[3] == 71 && b[4] == 13 && b[5] == 10 && b[6] == 26 && b[7] == 10;
    }

    public static boolean isGif(InputStream in) throws IOException {
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Input stream must support mark");
        }
        byte[] b = new byte[6];
        try {
            in.mark(30);
            in.read(b);
        }
        finally {
            in.reset();
        }
        return b[0] == 71 && b[1] == 73 && b[2] == 70 && b[3] == 56 && (b[4] == 55 || b[4] == 57) && b[5] == 97;
    }

    public static void resize(InputStream in, OutputStream out, int maxWidth, int maxHeight, int type, float quality, String[] watermark, Font font, Color fontColor) throws IOException {
        if (type < 1 || type > 7) {
            throw new IOException("can not support type: " + type + ", type must be in [1-7] ");
        }
        if (type == 1) {
            if (!ImageUtils.isJpg(in)) {
                throw new IOException("image format is not jpg ");
            }
            ImageUtils.resizeJpg(in, out, maxWidth, maxHeight, quality, watermark, font, fontColor);
            return;
        }
        if (type == 2) {
            if (!ImageUtils.isPng(in)) {
                throw new IOException("image format is not png ");
            }
            ImageUtils.resizePng(in, out, maxWidth, maxHeight, quality, watermark, font, fontColor);
            return;
        }
        if (type == 3) {
            if (ImageUtils.isJpg(in)) {
                ImageUtils.resizeJpg(in, out, maxWidth, maxHeight, quality, watermark, font, fontColor);
                return;
            }
            if (ImageUtils.isPng(in)) {
                ImageUtils.resizePng(in, out, maxWidth, maxHeight, quality, watermark, font, fontColor);
                return;
            }
            throw new IOException("image format is not jpg or png ");
        }
        if (type == 4) {
            if (!ImageUtils.isGif(in)) {
                throw new IOException("image format is not gif ");
            }
            ImageUtils.resizeGif(in, out, maxWidth, maxHeight, quality, watermark, font, fontColor);
            return;
        }
        if (type == 5) {
            if (ImageUtils.isJpg(in)) {
                ImageUtils.resizeJpg(in, out, maxWidth, maxHeight, quality, watermark, font, fontColor);
                return;
            }
            if (ImageUtils.isGif(in)) {
                ImageUtils.resizeGif(in, out, maxWidth, maxHeight, quality, watermark, font, fontColor);
                return;
            }
            throw new IOException("image format is not jpg or gif ");
        }
        if (type == 6) {
            if (ImageUtils.isPng(in)) {
                ImageUtils.resizePng(in, out, maxWidth, maxHeight, quality, watermark, font, fontColor);
                return;
            }
            if (ImageUtils.isGif(in)) {
                ImageUtils.resizeGif(in, out, maxWidth, maxHeight, quality, watermark, font, fontColor);
                return;
            }
            throw new IOException("image format is not png or gif ");
        }
        if (type == 7) {
            if (ImageUtils.isJpg(in)) {
                ImageUtils.resizeJpg(in, out, maxWidth, maxHeight, quality, watermark, font, fontColor);
                return;
            }
            if (ImageUtils.isPng(in)) {
                ImageUtils.resizePng(in, out, maxWidth, maxHeight, quality, watermark, font, fontColor);
                return;
            }
            if (ImageUtils.isGif(in)) {
                ImageUtils.resizeGif(in, out, maxWidth, maxHeight, quality, watermark, font, fontColor);
                return;
            }
            throw new IOException("image format is not jpg or png or gif ");
        }
    }

    public static void resizeJpg(InputStream in, OutputStream out, int maxWidth, int maxHeight, float quality, String[] watermark, Font font, Color fontColor) throws IOException {
        ImageUtils.checkParams(in, out, maxWidth, maxHeight, quality);
        BufferedImage image = ImageIO.read(in);
        image = Scalr.resize(image, Scalr.Method.AUTOMATIC, Scalr.Mode.AUTOMATIC, maxWidth, maxHeight, new BufferedImageOp[0]);
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setComposite(AlphaComposite.getInstance(10, 1.0f));
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.drawImage((Image)image, 0, 0, null);
        image = bufferedImage;
        if (watermark != null && watermark.length > 0) {
            ImageUtils.makeWatermark(watermark, image, font, fontColor);
        }
        ImageIO.write((RenderedImage)image, "jpg", out);
    }

    public static void resizePng(InputStream in, OutputStream out, int maxWidth, int maxHeight, float quality, String[] watermark, Font font, Color fontColor) throws IOException {
        ImageUtils.checkParams(in, out, maxWidth, maxHeight, quality);
        BufferedImage image = ImageIO.read(in);
        image = Scalr.resize(image, Scalr.Method.AUTOMATIC, Scalr.Mode.AUTOMATIC, maxWidth, maxHeight, new BufferedImageOp[0]);
        if (watermark != null && watermark.length > 0) {
            ImageUtils.makeWatermark(watermark, image, font, fontColor);
        }
        ImageIO.write((RenderedImage)image, "png", out);
    }

    public static void resizeGif(InputStream in, OutputStream out, int maxWidth, int maxHeight, float quality, String[] watermark, Font font, Color fontColor) throws IOException {
        ImageUtils.checkParams(in, out, maxWidth, maxHeight, quality);
        GifDecoder gd = new GifDecoder();
        int status = gd.read(in);
        if (status != 0) {
            return;
        }
        AnimatedGifEncoder ge = new AnimatedGifEncoder();
        ge.start(out);
        ge.setRepeat(0);
        int i = 0;
        while (i < gd.getFrameCount()) {
            BufferedImage frame = gd.getFrame(i);
            BufferedImage rescaled = Scalr.resize(frame, Scalr.Method.AUTOMATIC, Scalr.Mode.AUTOMATIC, maxWidth, maxHeight, new BufferedImageOp[0]);
            if (watermark != null && watermark.length > 0) {
                ImageUtils.makeWatermark(watermark, rescaled, font, fontColor);
            }
            int delay = gd.getDelay(i);
            ge.setDelay(delay);
            ge.addFrame(rescaled);
            ++i;
        }
        ge.finish();
    }

    public static void makeWatermark(String[] text, BufferedImage image, Font font, Color fontColor) {
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (font != null) {
            graphics.setFont(font);
        } else {
            graphics.setFont(FONT);
        }
        if (fontColor == null) {
            fontColor = COLOR;
        }
        graphics.setColor(fontColor);
        int i = 0;
        while (i < text.length) {
            if (!"".equals(text[i].trim())) {
                FontRenderContext context = graphics.getFontRenderContext();
                Rectangle2D fontRectangle = font.getStringBounds(text[i], context);
                int sw = (int)fontRectangle.getWidth();
                int sh = (int)fontRectangle.getHeight();
                if (text.length - i == 1) {
                    graphics.drawString(text[i], image.getWidth() - sw - 6, image.getHeight() - 8);
                } else {
                    graphics.drawString(text[i], image.getWidth() - sw - 6, image.getHeight() - sh * (text.length - 1) - 8);
                }
            }
            ++i;
        }
        graphics.dispose();
    }

    private static void checkParams(InputStream in, OutputStream out, int maxWidth, int maxHeight, float quality) throws IOException {
        if (in == null) {
            throw new IOException("InputStream can not be null ");
        }
        if (out == null) {
            throw new IOException("OutputStream can not be null ");
        }
        if (maxWidth < 1 || maxHeight < 1) {
            throw new IOException("maxWidth or maxHeight can not be less than 1 ");
        }
        if (quality < 0.0f || quality > 1.0f) {
            throw new IOException("quality must be in [0-1] ");
        }
    }

    public static void makePng(String text, OutputStream out, int maxWidth, int cHeight, Font font, Color fontColor) throws IOException {
        int xM = 8;
        int yM = 25;
        cHeight = cHeight <= 0 ? 0 : cHeight;
        int maxHeight = 0;
        if (font == null) {
            font = FONT;
        }
        ImageUtils.buildFontRec(font);
        int spaceWidth = FONT_REC_MAP.get(font).get("\u3000")[0];
        int spaceHeight = FONT_REC_MAP.get(font).get("\u3000")[1];
        int line = 0;
        int lineWidth = 0;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            int sw = spaceWidth;
            int sh = spaceHeight;
            if (cHeight == 0) {
                cHeight = sh;
            }
            if (c == '\n') {
                ++line;
                lineWidth = 0;
            } else {
                if (c == '\t') {
                    sw = spaceWidth * 2;
                } else if (c >= '\u0000' && c < '\u0080') {
                    sw = FONT_REC_MAP.get(font).get(String.valueOf(c))[0];
                }
                if ((lineWidth += sw) > maxWidth - 20) {
                    ++line;
                    lineWidth = 0 + sw;
                } else if (lineWidth == maxWidth - 20) {
                    ++line;
                    lineWidth = 0;
                }
            }
            ++i;
        }
        maxHeight = yM * 2 + cHeight * line;
        BufferedImage bufferedImage = new BufferedImage(maxWidth, maxHeight, 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        BufferedImage image = g2d.getDeviceConfiguration().createCompatibleImage(maxWidth, maxHeight, 3);
        g2d.dispose();
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setFont(font);
        if (fontColor != null) {
            graphics.setColor(fontColor);
        } else {
            graphics.setColor(FONT_COLOR);
        }
        line = 0;
        int lineWidth2 = 0;
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < text.length()) {
            char c = text.charAt(i2);
            String str = String.valueOf(c);
            int sw = spaceWidth;
            int sh = cHeight;
            if (c == '\n') {
                graphics.drawString(sb.toString(), xM, yM + line * sh);
                sb = new StringBuilder();
                ++line;
                lineWidth2 = 0;
            } else {
                if (c == '\t') {
                    str = "\u3000\u3000";
                    sw = spaceWidth * 2;
                } else if (c > '\u0000' && c < '\u0080') {
                    sw = FONT_REC_MAP.get(font).get(String.valueOf(c))[0];
                }
                if ((lineWidth2 += sw) > maxWidth - 20) {
                    graphics.drawString(sb.toString(), xM, yM + line * sh);
                    sb = new StringBuilder();
                    sb.append(str);
                    ++line;
                    lineWidth2 = 0 + sw;
                } else if (lineWidth2 == maxWidth - 20) {
                    sb.append(str);
                    graphics.drawString(sb.toString(), xM, yM + line * sh);
                    sb = new StringBuilder();
                    ++line;
                    lineWidth2 = 0;
                } else {
                    sb.append(str);
                    if (i2 == text.length() - 1) {
                        graphics.drawString(sb.toString(), xM, yM + line * sh);
                    }
                }
            }
            ++i2;
        }
        graphics.dispose();
        ImageIO.write((RenderedImage)image, "png", out);
    }

    public static synchronized void buildFontRec(Font font) {
        if (FONT_REC_MAP.get(font) != null) {
            return;
        }
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        BufferedImage nImage = new BufferedImage(1, 1, 1);
        Graphics2D ng = nImage.createGraphics();
        FontRenderContext context = ng.getFontRenderContext();
        Rectangle2D rect = font.getStringBounds("\u3000", context);
        int spaceWidth = (int)rect.getWidth();
        int spaceHeight = (int)rect.getHeight();
        map.put("\u3000", new int[]{spaceWidth, spaceHeight});
        int i = 0;
        while (i < 128) {
            rect = font.getStringBounds(String.valueOf((char)i), context);
            spaceWidth = (int)rect.getWidth();
            spaceHeight = (int)rect.getHeight();
            map.put(String.valueOf((char)i), new int[]{spaceWidth, spaceHeight});
            ++i;
        }
        FONT_REC_MAP.put(font, map);
    }
}

