/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.res.utils;

import com.crawler.res.common.QiniuProperties;
import com.crawler.res.utils.FileUtils;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.processing.OperationManager;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import com.qiniu.util.UrlSafeBase64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QiNiuUtils {
    private static final Logger logger = LoggerFactory.getLogger(QiNiuUtils.class);
    public static final String DOMAIN = QiniuProperties.getProperty("qiniu.domain");
    private static final String ACCESS_KEY = QiniuProperties.getProperty("qiniu.access_key");
    private static final String SECRET_KEY = QiniuProperties.getProperty("qiniu.secret_key");
    private static final String BUCKET_NAME = QiniuProperties.getProperty("qiniu.bucket");
    private static final String ZONE = QiniuProperties.getProperty("qiniu.zone");
    public static final String VIDEO_DOMAIN = QiniuProperties.getProperty("qiniu.video.domain", DOMAIN);
    public static final String VIDEO_BUCKET_NAME = QiniuProperties.getProperty("qiniu.video.bucket", BUCKET_NAME);
    private static final String PIPELINE = QiniuProperties.getProperty("qiniu.pipeline", "admin_merge_radio");
    private static final String NOTIFY_URL = QiniuProperties.getProperty("qiniu.notify");
    private static final String SALT = QiniuProperties.getProperty("qiniu.salt", "crawler");
    private static final Auth auth = Auth.create((String)ACCESS_KEY, (String)SECRET_KEY);
    private static final Configuration cfg;

    static {
        Zone zone = Zone.autoZone();
        if ("zone0".equals(ZONE)) {
            zone = Zone.zone0();
        } else if ("zone1".equals(ZONE)) {
            zone = Zone.zone1();
        } else if ("zone2".equals(ZONE)) {
            zone = Zone.zone2();
        } else if ("zoneNa0".equals(ZONE)) {
            zone = Zone.zoneNa0();
        }
        cfg = new Configuration(zone);
    }

    public static String getUpToken() {
        return QiNiuUtils.getUpToken(BUCKET_NAME);
    }

    public static String getUpToken(String key, boolean override) {
        return QiNiuUtils.getUpToken(BUCKET_NAME, key, override);
    }

    public static String getUpToken(String bucketName) {
        return QiNiuUtils.getUpToken(bucketName, null, false);
    }

    public static String getUpToken(String bucketName, String key, boolean override) {
        StringMap policy = null;
        if (override) {
            return auth.uploadToken(bucketName, key);
        }
        return auth.uploadToken(bucketName, null, 360000L, policy, true);
    }

    public static String getUpToken(String accessKey, String secretKey, String bucketName) {
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        return QiNiuUtils.getUpToken(auth, bucketName);
    }

    public static String getUpToken(Auth auth, String bucketName) {
        return auth.uploadToken(bucketName, null, 360000L, null, true);
    }

    public static String getPrivateDownloadUrl(String baseUrl, Long expires) {
        if (baseUrl == null || "".equals(baseUrl)) {
            return baseUrl;
        }
        if (expires == null) {
            return QiNiuUtils.getPrivateDownloadUrl(baseUrl);
        }
        return auth.privateDownloadUrl(baseUrl, expires.longValue());
    }

    public static String getPrivateDownloadUrl(String baseUrl) {
        if (baseUrl == null || "".equals(baseUrl)) {
            return baseUrl;
        }
        return auth.privateDownloadUrl(baseUrl);
    }

    public static String upload(String bucketName, byte[] data, String fileName) {
        try {
            System.out.println(cfg);
            UploadManager uploadManager = new UploadManager(cfg);
            Response res = uploadManager.put(data, fileName, QiNiuUtils.getUpToken(bucketName));
            logger.info("\u4e0a\u4f20\u54cd\u5e94\u4fe1\u606f\uff1a" + res.bodyString());
            return String.valueOf(DOMAIN) + "/" + fileName;
        }
        catch (QiniuException e) {
            logger.error(e.getMessage());
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    public static String upload(String bucketName, InputStream inputStream, String fileName, String mimeType) {
        try {
            System.out.println(cfg);
            UploadManager uploadManager = new UploadManager(cfg);
            Response res = uploadManager.put(inputStream, fileName, QiNiuUtils.getUpToken(bucketName), null, mimeType);
            logger.info("\u4e0a\u4f20\u54cd\u5e94\u4fe1\u606f\uff1a" + res.bodyString());
            return String.valueOf(DOMAIN) + "/" + fileName;
        }
        catch (QiniuException e) {
            logger.error(e.getMessage());
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    public static String uploadByBtye(String bucketName, InputStream inputStream, String fileName) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            int rc = 0;
            while ((rc = inputStream.read(buff, 0, 1024)) > 0) {
                byteArrayOutputStream.write(buff, 0, rc);
            }
            byte[] data = byteArrayOutputStream.toByteArray();
            return QiNiuUtils.upload(data, fileName);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    public static String upload(byte[] data, String fileName) {
        return QiNiuUtils.upload(BUCKET_NAME, data, fileName);
    }

    public static String uploadByBtye(InputStream inputStream, String fileName) {
        return QiNiuUtils.uploadByBtye(BUCKET_NAME, inputStream, fileName);
    }

    public static String upload(InputStream inputStream, String fileName, String mimeType) {
        return QiNiuUtils.upload(BUCKET_NAME, inputStream, fileName, mimeType);
    }

    public static String upload(InputStream inputStream, String fileName) {
        return QiNiuUtils.upload(BUCKET_NAME, inputStream, fileName, null);
    }

    public static String upload(String bucket, String filePath, String fileName) {
        return QiNiuUtils.upload(bucket, filePath, fileName, false);
    }

    public static String upload(String bucket, String filePath, String fileName, boolean override) {
        try {
            System.out.println(cfg);
            UploadManager uploadManager = new UploadManager(cfg);
            Response res = uploadManager.put(filePath, fileName, QiNiuUtils.getUpToken(bucket, fileName, override));
            logger.info("\u4e0a\u4f20\u54cd\u5e94\u4fe1\u606f\uff1a" + res.bodyString());
            return String.valueOf(DOMAIN) + "/" + fileName;
        }
        catch (QiniuException e) {
            logger.error(e.getMessage());
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    public static String upload(String filePath, String fileName) {
        return QiNiuUtils.upload(BUCKET_NAME, filePath, fileName);
    }

    public static String upload(String filePath, String fileName, boolean override) {
        return QiNiuUtils.upload(BUCKET_NAME, filePath, fileName, override);
    }

    public static String uploadVideo(String bucketName, byte[] data, String fileName) {
        try {
            UploadManager uploadManager = new UploadManager(cfg);
            Response res = uploadManager.put(data, fileName, QiNiuUtils.getUpToken(bucketName));
            logger.info("\u4e0a\u4f20\u54cd\u5e94\u4fe1\u606f\uff1a" + res.bodyString());
            return String.valueOf(VIDEO_DOMAIN) + "/" + fileName;
        }
        catch (QiniuException e) {
            logger.error(e.getMessage());
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    public static String uploadVideo(byte[] data, String fileName) {
        return QiNiuUtils.uploadVideo(VIDEO_BUCKET_NAME, data, fileName);
    }

    public static String uploadVideo(String bucket, String filePath, String fileName) {
        try {
            UploadManager uploadManager = new UploadManager(cfg);
            Response res = uploadManager.put(filePath, fileName, QiNiuUtils.getUpToken(bucket));
            logger.info("\u4e0a\u4f20\u54cd\u5e94\u4fe1\u606f\uff1a" + res.bodyString());
            return String.valueOf(VIDEO_DOMAIN) + "/" + fileName;
        }
        catch (QiniuException e) {
            logger.error(e.getMessage());
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    public static String uploadVideo(String filePath, String fileName) {
        return QiNiuUtils.uploadVideo(VIDEO_BUCKET_NAME, filePath, fileName);
    }

    public static JSONObject imageInfo(String url) {
        JSONObject result = new JSONObject();
        try {
            Client client = new Client();
            url = url.split("\\?")[0];
            Response response = client.get(String.valueOf(url) + "?imageInfo");
            result = JSONObject.fromObject((Object)response.bodyString());
        }
        catch (QiniuException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static JSONObject avinfo(String url) {
        JSONObject result = new JSONObject();
        try {
            Client client = new Client();
            url = url.split("\\?")[0];
            Response response = client.get(String.valueOf(url) + "?avinfo");
            JSONObject json = JSONObject.fromObject((Object)response.bodyString());
            JSONArray streams = json.getJSONArray("streams");
            JSONObject format = json.getJSONObject("format");
            int width = 0;
            int height = 0;
            int rotate = 0;
            int i = 0;
            while (i < streams.size()) {
                JSONObject baseInfo = streams.getJSONObject(i);
                if (baseInfo.containsKey((Object)"width")) {
                    JSONObject tags;
                    width = baseInfo.getInt("width");
                    height = baseInfo.getInt("height");
                    if (!baseInfo.containsKey((Object)"tags") || !(tags = baseInfo.getJSONObject("tags")).containsKey((Object)"rotate") || (rotate = Math.abs(tags.getInt("rotate"))) != 90 && rotate != 270) break;
                    int tmp = width;
                    width = height;
                    height = tmp;
                    break;
                }
                ++i;
            }
            if (width == 0) {
                width = 960;
                height = 544;
            }
            result.put((Object)"width", (Object)width);
            result.put((Object)"height", (Object)height);
            result.put((Object)"size", format.get("size"));
            result.put((Object)"duration", format.get("duration"));
        }
        catch (QiniuException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getThumb(String url, int width, int height, int quality) {
        return String.format("%s?imageView2/2/w/%d/h/%d/q/%d", url, width, height, quality);
    }

    public static String getThumb(String url, int width, int height) {
        return String.format("%s?imageView2/2/w/%d/h/%d", url, width, height);
    }

    public static String getThumb(String url, int width) {
        return String.format("%s?imageView2/2/w/%d", url, width);
    }

    public static String clip(String url, int width, int height) {
        url = url.split("\\?")[0];
        return String.format("%s?imageView2/1/w/%d/h/%d", url, width, height);
    }

    public static String uploadVideoCover(String url, int width, int height, int offset) {
        String cover = String.format("%s?vframe/jpg/offset/%d/w/%d/h/%d", url, offset, width, height);
        String fileName = UUID.randomUUID() + ".jpg";
        return QiNiuUtils.transfer(cover, fileName);
    }

    public static String uploadVideoCover(String url, int width, int height) {
        return QiNiuUtils.uploadVideoCover(url, width, height, 1);
    }

    public static String getVideoCover(String url, int width, int height, int offset) {
        return String.format("%s?vframe/jpg/offset/%d/w/%d/h/%d", url, offset, width, height);
    }

    public static String getVideoCover(String url, int width, int height) {
        return QiNiuUtils.getVideoCover(url, width, height, 1);
    }

    public static String transfer(String url, String fileName) {
        byte[] types;
        if (fileName == null) {
            fileName = UUID.randomUUID() + url.substring(url.lastIndexOf("."));
        }
        if ((types = QiNiuUtils.toByte(url)) == null) {
            return null;
        }
        QiNiuUtils.upload(types, fileName);
        return String.valueOf(DOMAIN) + "/" + fileName;
    }

    public static String transfer(String url) {
        return QiNiuUtils.transfer(url, null);
    }

    private static byte[] toByte(String urlString) {
        try {
            URL url = new URL(urlString);
            URLConnection con = url.openConnection();
            con.setConnectTimeout(5000);
            InputStream is = con.getInputStream();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = is.read(buffer))) {
                output.write(buffer, 0, n);
            }
            is.close();
            return output.toByteArray();
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String toMp4(String fileName, String newFileName) throws QiniuException {
        return QiNiuUtils.toMp4(fileName, newFileName, "640x360");
    }

    public static String toMp4(String fileName, String newFileName, String resolution) throws QiniuException {
        if (resolution == null || "".equals(resolution)) {
            resolution = "640x360";
        }
        String pipeline = PIPELINE;
        String saveAs = UrlSafeBase64.encodeToString((String)(String.valueOf(VIDEO_BUCKET_NAME) + ":" + newFileName));
        String fops = "avthumb/mp4/s/" + resolution + "/vcodec/libx264|saveas/" + saveAs;
        OperationManager operationMgr = new OperationManager(auth, cfg);
        String persistentId = operationMgr.pfop(VIDEO_BUCKET_NAME, fileName, fops, pipeline, NOTIFY_URL);
        return persistentId;
    }

    public static String m3u8(String fileName) throws QiniuException {
        String m3u8Path = QiNiuUtils.getM3u8Path(fileName);
        String pipeline = PIPELINE;
        String saveAs = UrlSafeBase64.encodeToString((String)(String.valueOf(VIDEO_BUCKET_NAME) + ":" + m3u8Path));
        String fops = "avthumb/m3u8/noDomain/1|saveas/" + saveAs;
        OperationManager operationMgr = new OperationManager(auth, cfg);
        String persistentId = operationMgr.pfop(VIDEO_BUCKET_NAME, fileName, fops, pipeline, NOTIFY_URL);
        return persistentId;
    }

    public static void remove(String url) throws QiniuException {
        BucketManager bucketManager = new BucketManager(auth, cfg);
        url = url.split("\\?")[0];
        String key = url.replace(String.valueOf(DOMAIN) + "/", "");
        bucketManager.delete(BUCKET_NAME, key);
    }

    public static String getM3u8Path(String fileName) {
        if (fileName.contains("/")) {
            fileName = fileName.substring(fileName.lastIndexOf("/"));
        }
        return "video/m3u8/" + FileUtils.shortMd5(fileName, SALT) + ".m3u8";
    }

    public static String getM3u8FullPath(String fileName) {
        return String.valueOf(VIDEO_DOMAIN) + "/" + QiNiuUtils.getM3u8Path(fileName);
    }

    public static String getM3u8PrivatePath(String fileName) {
        String path = QiNiuUtils.getM3u8FullPath(fileName);
        return QiNiuUtils.getPrivateDownloadUrl(String.valueOf(path) + "?pm3u8/0");
    }

    public static List<FileInfo> listFiles(String bucket, String prefix, int limit, String delimiter) {
        BucketManager bucketManager = new BucketManager(auth, cfg);
        BucketManager.FileListIterator fileListIterator = bucketManager.createFileListIterator(bucket, prefix, limit, delimiter);
        ArrayList<FileInfo> list = new ArrayList<FileInfo>();
        while (fileListIterator.hasNext()) {
            FileInfo[] items;
            FileInfo[] fileInfoArray = items = fileListIterator.next();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                FileInfo item = fileInfoArray[n2];
                list.add(item);
                ++n2;
            }
        }
        return list;
    }

    public static List<FileInfo> listFiles(String bucket) {
        return QiNiuUtils.listFiles(bucket, "", 1000, "");
    }

    public static List<FileInfo> listFiles() {
        return QiNiuUtils.listFiles(BUCKET_NAME);
    }
}

