package com.baidu.ueditor.upload;

import java.util.Map;
import java.util.UUID;

import org.apache.commons.codec.binary.Base64;

import com.baidu.ueditor.define.AppInfo;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import com.crawler.res.utils.QiNiuUtils;

public final class Base64Uploader {

	public static State save(String content, Map<String, Object> conf) {
		
		byte[] data = decode(content);

		long maxSize = ((Long) conf.get("maxSize")).longValue();

		if (!validSize(data, maxSize)) {
			return new BaseState(false, AppInfo.MAX_SIZE);
		}

		String suffix = FileType.getSuffix("JPG");

		try{
			String fileName =  UUID.randomUUID() + suffix;
			QiNiuUtils.upload(data, fileName);
			String url = QiNiuUtils.DOMAIN  + "/" + fileName;
			State storageState = new BaseState(true);
			if (storageState.isSuccess()) {
				storageState.putInfo( "size", content.length());
				storageState.putInfo( "title", (String) conf.get("filename"));
				storageState.putInfo("url", url);
				storageState.putInfo("type", suffix);
				storageState.putInfo("original",  "");
			}
			return storageState;
		}
		catch (RuntimeException ex) {
			return new BaseState(false, AppInfo.IO_ERROR);
		}
	}

	private static byte[] decode(String content) {
		return Base64.decodeBase64(content);
	}

	private static boolean validSize(byte[] data, long length) {
		return data.length <= length;
	}
	
}