package com.baidu.ueditor.upload;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import com.baidu.ueditor.define.AppInfo;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import com.crawler.res.utils.QiNiuUtils;

/**
 * 二进制上传
 * @author Rubekid
 *
 * 2017年4月16日 下午12:42:55
 */
public class BinaryUploader {

	public static final State save(HttpServletRequest request, Map<String, Object> conf) {
		boolean isAjaxUpload = request.getHeader( "X_Requested_With" ) != null;

		if (!ServletFileUpload.isMultipartContent(request)) {
			return new BaseState(false, AppInfo.NOT_MULTIPART_CONTENT);
		}

		ServletFileUpload upload = new ServletFileUpload(
				new DiskFileItemFactory());

        if ( isAjaxUpload ) {
            upload.setHeaderEncoding( "UTF-8" );
        }

		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		MultiValueMap<String, MultipartFile> map = multipartRequest.getMultiFileMap();
		
		CommonsMultipartFile multipartFile = null;
		for (Entry<String, List<MultipartFile>> entry : map.entrySet()) {
			if(entry.getValue()!=null && entry.getValue().size() > 0){
				multipartFile = (CommonsMultipartFile) entry.getValue().get(0);
				break;
			}
			
		}
		
		if(multipartFile == null ){
			return new BaseState(false, AppInfo.NOTFOUND_UPLOAD_DATA);
		}

		String originFileName = multipartFile.getFileItem().getName();
		String suffix = FileType.getSuffixByFilename(originFileName);
		originFileName = originFileName.substring(0, originFileName.length() - suffix.length());
		if (!validType(suffix, (String[]) conf.get("allowFiles"))) {
			return new BaseState(false, AppInfo.NOT_ALLOW_FILE_TYPE);
		}
		try{
			String fileName =  UUID.randomUUID() + suffix;
			QiNiuUtils.upload(multipartFile.getBytes(), fileName);
			String url = QiNiuUtils.DOMAIN  + "/" + fileName;
			State storageState = new BaseState(true);
			if (storageState.isSuccess()) {
				storageState.putInfo( "size", multipartFile.getSize());
				storageState.putInfo( "title", originFileName);
				storageState.putInfo("url", url);
				storageState.putInfo("type", suffix);
				storageState.putInfo("original", originFileName + suffix);
			}
			return storageState;
		}
		catch (RuntimeException ex) {
			return new BaseState(false, AppInfo.IO_ERROR);
		}
	}

	private static boolean validType(String type, String[] allowTypes) {
		List<String> list = Arrays.asList(allowTypes);

		return list.contains(type);
	}
}
