package com.crawler.res.common;

import java.io.InputStream;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 系统配置
 * @author rubekid
 * @date 2016年7月16日
 */
public class ConfigProperties {
	
	private static final Logger logger = LoggerFactory.getLogger(ConfigProperties.class);
	
	private static Properties properties;
	
	static {
        try {
        	properties = new Properties();
            InputStream stream = ConfigProperties.class.getClassLoader().getResourceAsStream("config.properties");
            if (stream != null) {
                properties.load(stream);
            }
            
        } catch (Exception ex) {
            logger.warn("Read config.properties error.", ex);
        }
    }

	public static Properties getProperties() {
		return properties;
	}


}
