package com.crawler.res.common;

import java.io.IOException;
import java.util.List;
import java.util.UUID;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import com.crawler.res.utils.QiNiuUtils;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * 上传基类
 * @author Rubekid
 *
 * 2017年4月15日 下午9:57:43
 */
public abstract class UploaderBaseController {
	
	/**
	 * 获取上传token
	 * @return
	 */
	@RequestMapping(value = "/token", method = RequestMethod.GET)
	public Object token(){
		String token = QiNiuUtils.getUpToken();
		JSONObject json = new JSONObject();
		json.put("value", token);
		return json;
	}
	
	/**
	 * 文件上传
	 * @param multipartFiles
	 * @return
	 * @throws IOException 
	 * @throws Exception
	 */
	@ResponseBody
	@RequestMapping(method = RequestMethod.POST, headers = "content-type=multipart/form-data")
	public JSONObject upload( @RequestParam("file") CommonsMultipartFile multipartFile) throws IOException{
		return doFileUpload(multipartFile);
		
	}
	
	/**
	 * 图片上传
	 * @param multipartFile
	 * @return
	 * @throws IOException
	 */
	@ResponseBody
	@RequestMapping(value = "/image", method = RequestMethod.POST, headers = "content-type=multipart/form-data")
	public JSONObject imageUpload( @RequestParam("image") CommonsMultipartFile multipartFile,
			@RequestParam(value = "showInfo", required = false, defaultValue="false") Boolean showInfo) throws IOException{
		return doImageUpload(multipartFile, showInfo);
	}
	
	/**
	 * 图片批量上传
	 * @param multipartFile
	 * @return
	 * @throws IOException
	 */
	@ResponseBody
	@RequestMapping(value = "/images", method = RequestMethod.POST, headers = "content-type=multipart/form-data")
	public JSONArray batchImageUpload( @RequestParam(value = "images", required = false) List<CommonsMultipartFile> multipartFiles1, 
			@RequestParam(value = "images[]", required = false) List<CommonsMultipartFile> multipartFiles2,
			@RequestParam(value = "showInfo", required = false, defaultValue="false") Boolean showInfo) throws IOException{
		List<CommonsMultipartFile> multipartFiles = multipartFiles1 == null ? multipartFiles2 : multipartFiles1;
		JSONArray items = new JSONArray();
		for(CommonsMultipartFile multipartFile : multipartFiles){
			items.add(doImageUpload(multipartFile, showInfo));
		}
		return items;
	}
	
	/**
	 * 视频上传
	 * @param multipartFile
	 * @return
	 * @throws IOException
	 */
	@ResponseBody
	@RequestMapping(value = "/video", method = RequestMethod.POST, headers = "content-type=multipart/form-data")
	public JSONObject videoUpload( @RequestParam("video") CommonsMultipartFile multipartFile) throws IOException{
		String oFileName = multipartFile.getOriginalFilename();
		String ext = ".tmp";
		if(oFileName.contains(".")){
			ext = oFileName.substring(oFileName.lastIndexOf("."));
		}
		String baseFileName = UUID.randomUUID().toString();
		String fileName =  baseFileName + ext;
		String newFileName = baseFileName + ".mp4";
		JSONObject result = new JSONObject();
		
		if(!newFileName.equals(fileName)){
			fileName = "tmp/" + fileName;
			QiNiuUtils.upload(multipartFile.getBytes(), fileName);
			String persistentId = QiNiuUtils.toMp4(fileName, newFileName);
			result.put("persistentId", persistentId);
			result.put("url", QiNiuUtils.DOMAIN  + "/" + newFileName );
			return  result;
		}
		else{
			QiNiuUtils.upload(multipartFile.getBytes(), newFileName);
			String url = QiNiuUtils.DOMAIN  + "/" + newFileName;
			JSONObject info = QiNiuUtils.avinfo(url);
			result.put("url",  url);
			result.put("cover", QiNiuUtils.getVideoCover(url, info.getInt("width"), info.getInt("height")));
			result.put("size", info.get("size"));
			result.put("width", info.get("width"));
			result.put("height", info.get("height"));
			result.put("duration", info.get("duration"));
			return  result;
		}
	}
	
	
	/**
	 * 获取视频封面
	 * @param url
	 * @param width
	 * @param height
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "/cover", method = RequestMethod.GET)
	public JSONObject getCover(@RequestParam("url") String url, 
			@RequestParam("width") Integer width, @RequestParam("height") Integer height){
		JSONObject response = new JSONObject();
		response.put("cover", QiNiuUtils.uploadVideoCover(url, width, height));
		return response;
	}
	
	/**
	 * 查询视频状态
	 * @return
	 * @throws QiniuException 
	 */
	@ResponseBody
	@RequestMapping(value = "/video/query/status/{persistentId:.+}", method = RequestMethod.GET)
	public JSONObject queryVideoStatus(@PathVariable("persistentId") String persistentId) throws QiniuException{
		Client client = new Client();
		return JSONObject.fromObject(client.get("http://api.qiniu.com/status/get/prefop?id=" + persistentId).bodyString());
	}
	

	
	/**
	 * 图片上传操作
	 * @param multipartFile
	 * @return
	 * @throws IOException
	 */
	protected JSONObject doImageUpload(CommonsMultipartFile multipartFile, Boolean showInfo) throws IOException{
		String oFileName = multipartFile.getOriginalFilename();
		String ext = ".jpg";
		if(oFileName.contains(".")){
			ext = oFileName.substring(oFileName.lastIndexOf("."));
		}
		String fileName =  UUID.randomUUID() + ext;
		QiNiuUtils.upload(multipartFile.getBytes(), fileName);
		JSONObject result = new JSONObject();
		String url = QiNiuUtils.DOMAIN  + "/" + fileName;
		result.put("url", url );
		if(showInfo!= null && showInfo){
			JSONObject info = QiNiuUtils.imageInfo(url);
			result.put("size", info.get("size"));
			result.put("width", info.get("width"));
			result.put("height", info.get("height"));
		}
		return  result;
	}
	
	
	/**
	 * 普通文件上传
	 * @param multipartFile
	 * @return
	 * @throws IOException
	 */
	protected JSONObject doFileUpload(CommonsMultipartFile multipartFile) throws IOException{
		String oFileName = multipartFile.getOriginalFilename();
		String ext = ".tmp";
		if(oFileName.contains(".")){
			ext = oFileName.substring(oFileName.lastIndexOf("."));
		}
		String fileName =  UUID.randomUUID() + ext;
		QiNiuUtils.upload(multipartFile.getBytes(), fileName);
		JSONObject result = new JSONObject();
		result.put("url", QiNiuUtils.DOMAIN  + "/" + fileName );
		return  result;
	}
	
	
}
