package com.crawler.res.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.crawler.res.common.QiniuProperties;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.processing.OperationManager;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import com.qiniu.util.UrlSafeBase64;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * 七牛工具
 * @author rubekid
 *
 * 2016年12月31日 下午11:20:35
 */
public class QiNiuUtils {
	
	 private static final Logger logger = LoggerFactory.getLogger(QiNiuUtils.class);

	public static final String DOMAIN = QiniuProperties.getProperty("qiniu.domain");
	private static final String ACCESS_KEY = QiniuProperties.getProperty("qiniu.access_key");
	private static final String SECRET_KEY = QiniuProperties.getProperty("qiniu.secret_key");
	private static final String BUCKET_NAME = QiniuProperties.getProperty("qiniu.bucket");
	private static final String ZONE =  QiniuProperties.getProperty("qiniu.zone");
	private static final String PIPELINE =  QiniuProperties.getProperty("qiniu.pipeline", "admin_merge_radio");

	private static final Auth auth = Auth.create(ACCESS_KEY, SECRET_KEY);
	
	private static final Configuration cfg;
	
	/**
	 * 初始化配置
	 * 华东	Zone.zone0()
	 * 华北	Zone.zone1()
	 * 华南	Zone.zone2()
	 * 北美	Zone.zoneNa0()
	 */
	static{
		Zone zone = Zone.autoZone();
		if("zone0".equals(ZONE)){
			zone = Zone.zone0();
		}
		else if("zone1".equals(ZONE)){
			zone = Zone.zone1();
		}
		else if("zone2".equals(ZONE)){
			zone = Zone.zone2();
		}
		else if("zoneNa0".equals(ZONE)){
			zone = Zone.zoneNa0();
		}
		
		cfg = new Configuration(zone);
	}
	

	/**
	 * 简单上传，使用默认策略，只需要设置上传的空间名就可以了
	 * @return
	 */
	public static String getUpToken() {
		return auth.uploadToken(BUCKET_NAME, null, 3600 * 100, null, true);
	}
	
	/**
	 * 根据空间名获取
	 * @param buketName
	 * @return
	 */
	public static String getUpToken(String buketName){
		return auth.uploadToken(buketName, null, 3600 * 100, null, true);
	}

	/**
	 * 
	 * @param filePath "/.../...";
	 * @param fileName 上传到七牛后保存的文件名
	 * @throws IOException
	 */
	public static void upload(byte[] data, String fileName){
		try {
			System.out.println(cfg);
			// 创建上传对象
			UploadManager uploadManager = new UploadManager(cfg);

			// 调用put方法上传
			Response res = uploadManager.put(data, fileName, getUpToken());
			// 打印返回的信息
			logger.info("上传响应信息：" + res.bodyString());
		} catch (QiniuException e) {
			logger.error(e.getMessage());
			throw new RuntimeException("上传失败");
		}
	}
	
	/**
	 * 根据地址获取图片信息
	 * @param url
	 * @return
	 */
	public static JSONObject imageInfo(String url){
		
		JSONObject result = new JSONObject();
		try {
			Client client = new Client();
			url = url.split("\\?")[0];
			Response response = client.get(url + "?imageInfo");
			result = JSONObject.fromObject(response.bodyString());
		} catch (QiniuException e) {
			e.printStackTrace();
		}
		return result;
	}
	
	/**
	 * 视频信息
	 * @param url
	 * @return
	 */
	public static JSONObject avinfo(String url){
		JSONObject result = new JSONObject();
		try{
			Client client = new Client();
			url = url.split("\\?")[0];
			Response response = client.get(url + "?avinfo");
			JSONObject json =  JSONObject.fromObject(response.bodyString());
			JSONArray streams = json.getJSONArray("streams");
			
			JSONObject format = json.getJSONObject("format");
			int width = 0;
			int height = 0;
			int rotate = 0;
			for(int i=0; i<streams.size(); i++){
				JSONObject baseInfo = streams.getJSONObject(i);
				if(baseInfo.containsKey("width")){
					width = baseInfo.getInt("width");
					height = baseInfo.getInt("height");
					if(baseInfo.containsKey("tags")){						
						JSONObject tags = baseInfo.getJSONObject("tags");
						if(tags.containsKey("rotate")){
							rotate = Math.abs(tags.getInt("rotate"));
							if(rotate == 90 || rotate == 270){
								int tmp = width;
								width = height;
								height = tmp;
							}
						}
					}
					break;
				}
			}
			if(width == 0){
				width = 960;
				height = 544;
			}
			result.put("width", width);
			result.put("height", height);

			
			result.put("size", format.get("size"));
			result.put("duration", format.get("duration"));
		}
		catch(QiniuException e){
			e.printStackTrace();
		}
		return result;
	}
	
	/**
	 * 获取缩率图
	 * @param url
	 * @param width
	 * @param height
	 * @param quality
	 * @return
	 */
	public static String getThumb(String url, int width, int height, int quality){
		return String.format("%s?imageView2/2/w/%d/h/%d/q/%d", url, width, height, quality);
		
	}
	
	/**
	 *  获取缩率图
	 * @param url
	 * @param width
	 * @param height
	 * @return
	 */
	public static String getThumb(String url, int width, int height){
		return String.format("%s?imageView2/2/w/%d/h/%d", url, width, height);
	}
	
	/**
	 *  获取缩率图
	 * @param url
	 * @param width
	 * @return
	 */
	public static String getThumb(String url, int width){
		return String.format("%s?imageView2/2/w/%d", url, width);
	}
	
	/**
	 * 图片裁剪
	 * @param url
	 * @param width
	 * @param height
	 * @return
	 */
	public static String clip(String url, int width, int height){
		url = url.split("\\?")[0];
		return String.format("%s?imageView2/1/w/%d/h/%d", url, width, height);
	}
	
	/**
	 * 上传视频封面
	 * @param url
	 * @param width
	 * @param height
	 * @param offset
	 * @param 
	 * @return
	 */
	public static String uploadVideoCover(String url, int width, int height, int offset){
		String cover = String.format("%s?vframe/jpg/offset/%d/w/%d/h/%d", url, offset, width, height);
		String fileName = UUID.randomUUID() +  ".jpg";
		return  transfer(cover, fileName);
	}
	
	/**
	 * 上传视频封面
	 * @param url
	 * @param width
	 * @param height
	 * @return
	 */
	public static String uploadVideoCover(String url, int width, int height){
		return uploadVideoCover(url, width, height, 1);
	}
	
	/**
	 * 获取视频封面
	 * @param url
	 * @param width
	 * @param height
	 * @param offset
	 * @return
	 */
	public static String getVideoCover(String url, int width, int height, int offset){
		return String.format("%s?vframe/jpg/offset/%d/w/%d/h/%d", url, offset, width, height);
	}
	
	/**
	 * 获取视频封面
	 * @param url
	 * @param width
	 * @param height
	 * @return
	 */
	public static String getVideoCover(String url, int width, int height){
		return getVideoCover(url, width, height, 1);
	}
	
	/**
	 * 网络图片迁移
	 * @param url
	 * @param findName
	 * @throws IOException 
	 */
	public static String transfer(String url, String fileName){
		if(fileName == null){
			fileName = UUID.randomUUID() + url.substring(url.lastIndexOf("."));
		}
		byte[] types = toByte(url);
		if(types == null){
			return null;
		}
		QiNiuUtils.upload(types, fileName);
		return QiNiuUtils.DOMAIN + "/" + fileName;
	}
	
	/**
	 * 图片迁移
	 * @param url
	 * @return
	 * @throws IOException 
	 */
	public static String transfer(String url){
		return transfer(url, null);
	}
	
	/**
	 * 网络资源转byte[]
	 * @param urlString 网络地址
	 * @return
	 * @throws IOException
	 */
	private static byte[] toByte(String urlString){
		try{
			URL url = new URL(urlString);  
	        URLConnection con = url.openConnection();
	        con.setConnectTimeout(5*1000);  
	        InputStream is = con.getInputStream();
	        ByteArrayOutputStream output = new ByteArrayOutputStream();
	        byte[] buffer = new byte[4096];
	        int n = 0;
	        while (-1 != (n = is.read(buffer))) {
	            output.write(buffer, 0, n);
	        }
	        is.close();  
	        return output.toByteArray();
		}
        catch (IOException ex) {
			logger.error(ex.getMessage(), ex);
		}
		return null;
	}

	
	/**
	 * 执行转码和另存 操作
	 * @return
	 * @throws QiniuException 
	 */
	public static String toMp4(String fileName, String newFileName) throws QiniuException{
        String pipeline = PIPELINE;  //处理队列
        String saveAs = UrlSafeBase64.encodeToString(BUCKET_NAME + ":" + newFileName);        //saveas接口 参数
        String fops = "avthumb/mp4/vcodec/libx264|saveas/" + saveAs;                //处理命令 avthumb 和 saveas 通过管道符 |  进行连接
	    OperationManager operationMgr = new OperationManager(auth, cfg);
        String persistentId = operationMgr.pfop(BUCKET_NAME, fileName, fops, new StringMap().put("persistentPipeline", pipeline));
        return persistentId;
        
	}
	
	/**
	 * 删除
	 * @param url
	 * @throws QiniuException
	 */
	public static void remove(String url) throws QiniuException{
		// 创建上传对象
		BucketManager bucketManager = new BucketManager(auth, cfg);
		url = url.split("\\?")[0];
		String key = url.replace(QiNiuUtils.DOMAIN + "/", "");
		bucketManager.delete(BUCKET_NAME, key);
	}
	
}
