package com.crawler.res.common;

/**
 * 常量
 * @author rubekid
 *
 * 2018年2月12日 下午3:04:56
 */
public class ResConstant {
	
	public static final String WEBAPP_PATH = System.getProperty("waqf.webapp");
	
	/**
	 * 资源目录
	 */
	public static final String RESOURCE_PATH = ResConstant.class.getClassLoader().getResource("").getPath();
	
	/**
	 * 使用请求上传
	 */
	public static final Boolean IS_QINIU_MODE = ResProperties.getPropertyForBoolean("mode.qiniu", "false");
	
	/**
	 * 大图最大宽度750
	 */
	public static final int MAX_WIDTH = ResProperties.getPropertyForInteger("image.max.width", "750");

	/**
	 * 缩略图最大宽度400
	 */
	public static final int THUMB_MAX_WIDTH = ResProperties.getPropertyForInteger("thumb.max.width", "400");

	/**
	 * 缩略图最大宽度400
	 */
	public static final int THUMB_MAX_HEIGHT = ResProperties.getPropertyForInteger("thumb.max.height", "400");
	
	/**
	 * 大图大小限制（只对jpg格式有效）
	 */
	public static final int LIMIT_SIZE = ResProperties.getPropertyForInteger("image.max.size", "524288") ;

	/**
	 * 临时目录
	 */
	public static final String TEMP_PATH = ResProperties.getProperty("upload.temp.path", System.getProperty("java.io.tmpdir")) ;
	
	/**
	 * 水印比例
	 */
	public static final float WATERMARK_RATE = ResProperties.getPropertyForFloat("fileserver.watermark.rate", "0.5");

	/**
	 * 证书图片宽度限制
	 */
	public static final Integer CERTIFICATION_LIMIT = ResProperties.getPropertyForInteger("certification.max.width", "1024");
	
	/**
	 * 文件服务目录
	 */
	public static String FILE_SERVER_PATH = ResProperties.getProperty("fileserver.path", "{webappPath}", WEBAPP_PATH);
	
	/**
	 * 临时目录
	 */
	public static String FILE_SERVER_TEMP_DIR = ResProperties.getProperty("fileserver.temp.dir", "temp");
	
	/**
	 * 文件服务器域名
	 */
	public static String FILE_SERVER_DOMAIN = ResProperties.getProperty("fileserver.domain");
	
	/**
	 * 证件水印
	 */
	public static String WATERMARK_CERTIFICATION = ResProperties.getProperty("fileserver.watermark.certification", RESOURCE_PATH + "/watermark/certification.png");

	/**
	 * 富文本图片是否采用临时图片
	 */
	public static Boolean RICH_TEXT_TEMP_IMAGE = ResProperties.getPropertyForBoolean("richtext.image.temp", "false");


}
