package com.crawler.file.annotation;

import java.lang.reflect.Field;
import java.util.List;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.crawler.file.handler.TaskHandler;
import com.crawler.file.model.DataItem;
import com.crawler.file.runnable.FileUrlTask;
import com.crawler.res.utils.FileUtils;

@Aspect
@Component
public class FileUrlAspect {
	
	private Logger logger = LoggerFactory.getLogger(getClass());
	
	//Service层切点  
    @Pointcut("@annotation(com.crawler.file.annotation.FileUrlSync)")  
    public  void sync() {
    	System.out.println("sync");
    }
    
    
    /**
     * 
     * @param joinPoint
     */
    @SuppressWarnings({ "unchecked", "rawtypes" })
	@Before(value = "sync()")
    public void before(JoinPoint joinPoint){
    	Object[] args = joinPoint.getArgs();
    	for(Object obj : args){//查看参数值 
    		if(obj instanceof List){
    			List<Object> list = (List)obj;
        		for(Object item : list){
        			save(item);
        		}
            }
            else{
            	save(obj);
            }
    	}
    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
	@AfterReturning(returning="rvt", value = "sync()")
    public void afterReturning(JoinPoint joinPoint, Object rvt)  {
    	if(rvt instanceof List){
    		List<Object> list = (List)rvt;
    		for(Object obj : list){
    			sync(obj);
    		}
    	}
    	else{
    		sync(rvt);
    	}
    }
    
    /**
     * 保存文件
     * @param obj
     */
    private void save(Object obj){
    	try {
	    	if(obj.getClass().isAnnotationPresent(DTable.class)){
	    		Field[] fields = obj.getClass().getDeclaredFields();
	        	for(Field field : fields) {
	        		if(field.isAnnotationPresent(FileUrl.class)) {
	        			if (!(field.isAccessible())) {
	        				field.setAccessible(true);
	        			}
	        	        Object value = field.get(obj);
	        	        if(value == null){
	        	        	continue ;
	        	        }
	        	        String tempUrl = String.valueOf(value);
	        	        String[] urls = tempUrl.split(",");
	        	        boolean containTemp = false;
	        	        StringBuilder sb = new StringBuilder();
	        	        for(String url : urls){
	        	        	if(FileUtils.isTemp(url)){
		        	        	containTemp = true;
		        	        	url = FileUtils.save(url);
		        	        }
	        	        	sb.append(url).append(",");
	        	        }
	        	        
	        	        if(containTemp){
	        	        	field.set(obj, sb.toString().replaceAll(",$", ""));  
	        	        }
	        		}	
	        	}
			}
    	}catch(IllegalAccessException | IllegalArgumentException | SecurityException  ex) {
    		logger.error(ex.getMessage(), ex);
    	}
    }
    
    /**
     * 同步文件
     * @param obj
     */
    private void sync(Object obj){
    	try {
    		
    		DataItem dataItem = DataItem.parse(obj);
    		if(dataItem != null){
    			FileUrlTask task = new FileUrlTask(dataItem);
            	TaskHandler.append(task);
    		}
    		
    	}catch(IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException  ex) {
    		logger.error(ex.getMessage(), ex);
    	}
    }
}
