package com.crawler.file.handler;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

import com.crawler.res.common.ResProperties;

/**
 * 任务处理器
 * @author 
 *
 * 2018年4月26日 下午5:23:30
 */
public class TaskHandler {



	 /**
     * 线程线程池大小
     */
    public static final int MESSAGE_POOL_SIZE = ResProperties.getPropertyForInteger("message.pool.size", "3");
    
    /**
     * 线程池
     */
    private static ThreadPoolExecutor threadPool = (ThreadPoolExecutor) Executors.newFixedThreadPool(MESSAGE_POOL_SIZE);


    /**
     * 新增处理任务
     * @param message
     */
	public static void append(Runnable command){
		threadPool.execute(command);
	}
	

}
