package com.crawler.file.runnable;


import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.crawler.file.model.DataItem;
import com.crawler.file.service.FileUrlService;
import com.crawler.res.utils.FileUtils;

/**
 * 文件地址同步任务
 * @author 
 *
 * 2018年6月21日 下午7:04:50
 */
public class FileUrlTask implements Runnable{
	
	
	public final static Logger LOGGER = LoggerFactory.getLogger(FileUrlTask.class);

	/**
     * 文件地址服务
     */
	@Autowired
	private FileUrlService fileUrlService;
	
	
	/**
	 * 数据项
	 */
	private DataItem dataItem;
	
	public FileUrlTask(){}
	
	public FileUrlTask(DataItem dataItem){
		this.dataItem = dataItem;
	}

	
	@Override
	public void run() {
		try{
			Map<String, Object> data = dataItem.getFields();
        	if(data.size() > 0){
        		Map<String, String> urlMap = new HashMap<String, String>();
        		for(Map.Entry<String, Object> entry : data.entrySet()){
        			String key = entry.getKey();
        			String url = String.valueOf(entry.getValue());
        			String newUrl = "";
        			if(urlMap.containsKey(url)){
        				newUrl = urlMap.get(url);
        			}
        			else{
        				newUrl = FileUtils.syncToQiniu(url);
        				urlMap.put(url, newUrl);
        			}
        			dataItem.put(key, newUrl);
        		}
        		fileUrlService.update(dataItem);
        	}
			
			
		}
		catch( RuntimeException ex){
			LOGGER.error(ex.getMessage(), ex);
		}
		
	}

}
