package com.crawler.file.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.crawler.file.model.DataItem;
import com.qiniu.util.StringUtils;

/**
 * 文件路径服务
 * @author 
 *
 * 2019年4月9日 下午1:39:52
 */
@Service
public class FileUrlService {

	@Resource
	private JdbcTemplate jdbcTemplate;
	
	/**
	 * 查询数据
	 * @param dataItem
	 * @return
	 */
	public DataItem find(DataItem dataItem){
		Map<String, Object> fileds = dataItem.getFields();
		List<String> keys = new ArrayList<String>(fileds.keySet());
		
		String sql = "SELECT " + StringUtils.join(keys, ",") + " from " 
				+ dataItem.getTable() 
				+ " WHERE " + dataItem.getPk() + " = " + dataItem.getId();
		
		Map<String, Object> fields = jdbcTemplate.queryForMap(sql);
		if(fields == null || fields.size() == 0){
			return null;
		}
		dataItem.setFields(fields);
		return dataItem;
	}
	
	/**
	 * 更新数据
	 * @param dataItem
	 */
	@Transactional
	public void update(DataItem dataItem){
		String sql = "UPDATE " + dataItem.getTable() 
					+ " SET ";
		Map<String, Object> fileds = dataItem.getFields();
		for(Map.Entry<String, Object> entry : fileds.entrySet()) {
			sql += entry.getKey() + " = " + String.valueOf(entry.getValue()) + " ,";
		}
		sql = sql.substring(sql.length() -1);
		sql += " WHERE " + dataItem.getPk() + " = " + dataItem.getId();
		
		jdbcTemplate.update(sql);
		
	}
	
}
