package com.crawler.res.image;

import com.crawler.res.common.ResConstant;
import com.crawler.res.utils.FileUtils;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import java.io.*;


/**
 * 用户图片管理
 * @author Rubekid
 *
 */
public class Image {
	
	public static final int THUMB_WIDTH  = 200;
	public static final int THUMB_HEIGHT = 200;
	
	/**
	 * 源文件流
	 */
	private FileInputStream srcStream;
	
	/**
	 * 源文件
	 */
	private File srcFile;
	
	/**
	 * 保存图片名称
	 */
	private String fileName;
	
	/**
	 * 图片mimetype
	 */
	private String mimeType;
	
	/**
	 * 图片大小
	 */
	private long size;
	
	/**
	 * 图片类型
	 */
	private String type;
	
	public Image(CommonsMultipartFile multipartFile) throws Exception{
		this.mimeType = FileUtils.getMimeType(multipartFile);
		this.type = ImageScale.getType(mimeType);
		this.fileName = FileUtils.createFileName();
		srcFile = new File(ResConstant.TEMP_PATH + getFullName());
		if(!srcFile.exists()){
			srcFile.createNewFile();
		}
		multipartFile.transferTo(srcFile);
		this.srcStream = new FileInputStream(srcFile);
	}

	/**
	 * 图片压缩
	 * @param maxWidth
	 * @param maxHeight
	 * @param sizeLimit
	 * @throws IOException
	 */
	public ByteArrayOutputStream resize(int maxWidth, int maxHeight, int sizeLimit) throws IOException{
		if(ImageScale.TYPE_JPEG.equals(type)){
			ByteArrayOutputStream outStream = ImageScale.toOutputStream(srcStream);
			float quality = 0.8f;
			do{
				outStream = ImageScale.resize(srcFile, maxWidth, maxHeight, type, quality);
				quality -= 0.1;
			}while(sizeLimit > 0 && outStream.size() > sizeLimit && quality > 0.4);
			return outStream;
		}
		else{

			// 小图片不用处理压缩
			if(sizeLimit > 0 && srcFile.length() < sizeLimit){
				FileInputStream inputStream = new FileInputStream(srcFile);
				return ImageScale.toOutputStream(inputStream);

			}
			return ImageScale.resize(srcFile, maxWidth, maxHeight, type);
		}
	}

	public ByteArrayOutputStream getOutputStream() throws IOException {
		FileInputStream inputStream = new FileInputStream(srcFile);
		return ImageScale.toOutputStream(inputStream);
	}

	public byte[] getBytes() throws IOException {
		return getOutputStream().toByteArray();
	}

	public FileInputStream getSrcStream() {
		return srcStream;
	}

	public void setSrcStream(FileInputStream srcStream) {
		this.srcStream = srcStream;
	}

	public File getSrcFile() {
		return srcFile;
	}

	public void setSrcFile(File srcFile) {
		this.srcFile = srcFile;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}
	
	public String getFullName(){
		return fileName + "." + type;
	}

	public String getMimeType() {
		return mimeType;
	}

	public void setMimeType(String mimeType) {
		this.mimeType = mimeType;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}


	public long getSize() {
		return size;
	}

	public void setSize(long size) {
		this.size = size;
	}
	
	
	
	/**
	 * 删除临时文件
	 */
	public void removeTemp(){
		if(srcFile.exists()){
			srcFile.delete();
		}
	}
}
