package com.baidu.ueditor.upload;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.UUID;
import java.util.regex.Matcher;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import com.baidu.ueditor.define.AppInfo;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import com.crawler.ffmpeg.utils.StringUtils;
import com.crawler.res.common.QiniuProperties;
import com.crawler.res.common.ResConstant;
import com.crawler.res.image.Image;
import com.crawler.res.qiniu.QiniuClient;
import com.crawler.res.utils.FileUtils;
import com.crawler.res.utils.QiNiuUtils;

/**
 * 二进制上传
 * @author Rubekid
 *
 * 2017年4月16日 下午12:42:55
 */
public class BinaryUploader {

	public static final State save(HttpServletRequest request, Map<String, Object> conf) {
		return save(request, conf, null);
	}
	
	public static final State save(HttpServletRequest request, Map<String, Object> conf, QiniuClient qiniuClient) {
		boolean isAjaxUpload = request.getHeader( "X_Requested_With" ) != null;

		if (!ServletFileUpload.isMultipartContent(request)) {
			return new BaseState(false, AppInfo.NOT_MULTIPART_CONTENT);
		}

		ServletFileUpload upload = new ServletFileUpload(
				new DiskFileItemFactory());

        if ( isAjaxUpload ) {
            upload.setHeaderEncoding( "UTF-8" );
        }

		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		MultiValueMap<String, MultipartFile> map = multipartRequest.getMultiFileMap();
		
		CommonsMultipartFile multipartFile = null;
		for (Entry<String, List<MultipartFile>> entry : map.entrySet()) {
			if(entry.getValue()!=null && entry.getValue().size() > 0){
				multipartFile = (CommonsMultipartFile) entry.getValue().get(0);
				break;
			}
			
		}
		
		if(multipartFile == null ){
			return new BaseState(false, AppInfo.NOTFOUND_UPLOAD_DATA);
		}

		String originFileName = multipartFile.getFileItem().getName();
		String suffix = FileType.getSuffixByFilename(originFileName);
		originFileName = originFileName.substring(0, originFileName.length() - suffix.length());
		if (!validType(suffix, (String[]) conf.get("allowFiles"))) {
			return new BaseState(false, AppInfo.NOT_ALLOW_FILE_TYPE);
		}
		try{
			String fileName =  UUID.randomUUID() + suffix;

			String mimeType = FileUtils.getMimeType(multipartFile);
			byte[] bytes;
			if(ResConstant.MAX_WIDTH > 0 && mimeType.startsWith("image")){
				Image image = new Image(multipartFile);
				ByteArrayOutputStream outputStream = image.resize(ResConstant.MAX_WIDTH, 0, ResConstant.LIMIT_SIZE);
				image.removeTemp();
				bytes = outputStream.toByteArray();
			}
			else{
				bytes = multipartFile.getBytes();
			}
			
			
			String url = "";
			if(qiniuClient != null){
				url = qiniuClient.upload(bytes, fileName);
			}
			else if(!StringUtils.isNullOrEmpty(QiNiuUtils.ACCESS_KEY)){
				url = QiNiuUtils.upload(bytes, fileName);
			}
			else {
				String dateDir = getDateDir();
				String subfix = dateDir;
				if(ResConstant.RICH_TEXT_TEMP_IMAGE){
					subfix += ResConstant.FILE_SERVER_TEMP_DIR + File.separator + dateDir;
				}
				subfix += File.separator + "image";

				String storePath = ResConstant.FILE_SERVER_PATH + File.separator + subfix;// 存放我们上传的文件路径
				File distFile = new File(storePath + File.separator + fileName);
				if (!distFile.getParentFile().exists()) {
					distFile.getParentFile().mkdirs();// 如果目录不存在，创建目录
				}
				FileUtils.bytes2File(bytes, distFile);
				url = ResConstant.FILE_SERVER_DOMAIN + "/" + subfix.replaceAll(Matcher.quoteReplacement(File.separator), "/") + "/"  + fileName;
			}

			State storageState = new BaseState(true);
			if (storageState.isSuccess()) {
				storageState.putInfo( "size", multipartFile.getSize());
				storageState.putInfo( "title", originFileName);
				storageState.putInfo("url", url);
				storageState.putInfo("type", suffix);
				storageState.putInfo("original", originFileName + suffix);
			}
			return storageState;
		}
		catch (Exception ex) {
			return new BaseState(false, AppInfo.IO_ERROR);
		}
	}

	private static boolean validType(String type, String[] allowTypes) {
		List<String> list = Arrays.asList(allowTypes);

		return list.contains(type);
	}
	
	/**
	 * 获取当前日期目录
	 * @return
	 */
	protected static String getDateDir(){
		SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
		String dateDir = df.format(new Date());
		return dateDir;
	}
}
