package com.crawler.ffmpeg.bean;

/**
 * 视频
 * 
 * @author rubekid
 *
 */
public class Video {
	
	public static final int WIDTH = 320;
	
	public static final int HEIGHT = 240;
	
	public static final String DEFAULT_RESOLUTION = "320*240";
	
	public static final double RATE = (double) WIDTH / HEIGHT;
	
	/**
	 * 1M
	 */
	public static final int MAX_SIZE = 1024 * 1024 ; 
	
	/**
	 * 时长
	 */
	private long duration;
	
	
	/**
	 * 码率 比特率
	 */
	private long bitRate;
	
	/**
	 * 分辨率
	 * @return
	 */
	private String resolution;
	
	/**
	 * 宽
	 */
	private int width = WIDTH;
	
	/**
	 * 高
	 */
	private int height = HEIGHT;
	
	/**
	 * 源路径
	 */
	private String srcFile;
	
	/**
	 * 目标路径
	 */
	private String destFile;
	
	/**
	 * 类型
	 */
	private String type;
	
	/**
	 * 视频格式
	 */
	private String videoFormat;
	
	/**
	 * 音频格式
	 */
	private String audioFormat;
	
	/**
	 * 封面
	 */
	private String frontCover;
	
	/**
	 * 旋转角度
	 */
	private int rotate;
	
	/**
	 * 旋转
	 */
	private String transpose;
	
	/**
	 * 是否可识别
	 * @return
	 */
	private boolean support;
	



	public long getDuration() {
		return duration;
	}


	public void setDuration(long duration) {
		this.duration = duration;
	}


	public long getBitRate() {
		return bitRate;
	}


	public void setBitRate(long bitRate) {
		this.bitRate = bitRate;
	}


	public String getResolution() {
		return resolution;
	}


	public void setResolution(String resolution) {
		this.resolution = resolution;
	}



	public String getType() {
		return type;
	}


	public void setType(String type) {
		this.type = type;
	}


	public String getVideoFormat() {
		return videoFormat;
	}


	public void setVideoFormat(String videoFormat) {
		this.videoFormat = videoFormat;
	}


	public String getAudioFormat() {
		return audioFormat;
	}


	public void setAudioFormat(String audioFormat) {
		this.audioFormat = audioFormat;
	}


	public boolean isSupport() {
		return support;
	}


	public void setSupport(boolean support) {
		this.support = support;
	}


	public String getFrontCover() {
		return frontCover;
	}


	public void setFrontCover(String frontCover) {
		this.frontCover = frontCover;
	}


	public int getWidth() {
		return width;
	}


	public void setWidth(int width) {
		this.width = width;
	}


	public int getHeight() {
		return height;
	}


	public void setHeight(int height) {
		this.height = height;
	}


	public String getSrcFile() {
		return srcFile;
	}


	public void setSrcFile(String srcFile) {
		this.srcFile = srcFile;
	}


	public String getDestFile() {
		return destFile;
	}


	public void setDestFile(String destFile) {
		this.destFile = destFile;
	}
	
	/**
	 * 获取视频分辨率
	 */
	public void setDestResolution(){
		this.width = WIDTH;
		this.height = HEIGHT;
		String resolution  = this.getResolution();
		if(resolution!=null && (resolution.indexOf("x")>0 ||resolution.indexOf("*")>0) ){
			String[] nums = resolution.split("[x\\*]");
			if(nums.length == 2){
				int sWidth = Integer.parseInt(nums[0].trim());
				int sHeight = Integer.parseInt(nums[1].trim());
				double sRate = (double) sWidth / sHeight;
				this.width = sWidth;
				this.height = sHeight;
				if(sWidth >= sHeight){
					if(sRate > RATE && sWidth > WIDTH){
						this.width = WIDTH;
						this.height = this.width * sHeight / sWidth;
					}
					else if(sRate <= RATE && sHeight > HEIGHT){
						this.height = HEIGHT;
						this.width = this.height * sWidth / sHeight;
					}
				}
				else{
					if(1/sRate > RATE && sHeight > WIDTH){
						this.height = WIDTH;
						this.width = this.height * sWidth / sHeight;
					}
					else if(1/sRate <= RATE && sWidth > HEIGHT){
						this.width = HEIGHT;
						this.height = this.width * sHeight / sWidth;
					}
				}

				if(this.width % 2 !=0){
					this.width +=1;
				}
				if(this.height % 2 !=0){
					this.height +=1;
				}
				
			}
		}
		if(this.getRotate()==90 || this.getRotate() == 270){
			int tmp = this.width;
			this.width = this.height;
			this.height = tmp;
		}
	}
	
	/**
	 * 获取封面长宽比例
	 */
	public String getCoverResolution(){
		int coverHeight = this.height > HEIGHT ? HEIGHT : this.height;
		int coverWidth = coverHeight * this.getWidth() / this.getHeight();
		return coverWidth + "*" + coverHeight;
	}

	/**
	 * 获取视频压缩长宽比
	 */
	public String getDestResolution(){
		return this.getWidth() + "*" + this.getHeight();
	}


	public String getTranspose() {
		return transpose;
	}


	public void setTranspose(String transpose) {
		this.transpose = transpose;
	}


	public int getRotate() {
		return rotate;
	}


	public void setRotate(int rotate) {
		this.rotate = rotate;

    	switch (rotate) {
		case 90:
			this.setTranspose("transpose=1");
			break;
		case 180:
			this.setTranspose("transpose=2,transpose=2");
			break;
		case 270:
			this.setTranspose("transpose=2");
			break;
    	}	
	}
}
