package com.crawler.file.model;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import com.crawler.file.annotation.DTable;
import com.crawler.file.annotation.FileUrl;
import com.crawler.res.utils.FileUtils;

/**
 * 数据项
 * @author 
 *
 * 2019年4月9日 下午1:19:28
 */
public class DataItem {

	
	/**
	 * 表名
	 */
	private String table;
	
	/**
	 * 主键（默认id）
	 */
	private String pk = "id";
	
	/**
	 * 主键值
	 */
	private Object id;
	
	/**
	 * 字段
	 */
	private Map<String, Object> fields = new HashMap<String, Object>();

	public String getTable() {
		return table;
	}

	public void setTable(String table) {
		this.table = table;
	}

	public String getPk() {
		return pk;
	}

	public void setPk(String pk) {
		this.pk = pk;
	}

	public Object getId() {
		return id;
	}

	public void setId(Object id) {
		this.id = id;
	}

	public Map<String, Object> getFields() {
		return fields;
	}

	public void setFields(Map<String, Object> fields) {
		this.fields = fields;
	}
	
	public void put(String key, Object value){
		fields.put(key, value);
	}
	
	/**
	 * 对象转换
	 * @param obj
	 * @return
	 * @throws IllegalAccessException 
	 * @throws IllegalArgumentException 
	 * @throws SecurityException 
	 * @throws NoSuchFieldException 
	 */
	public static DataItem parse(Object obj) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException{
		if(obj == null){
			return null;
		}
		DataItem dataItem = null;
		Class<?> clazz = obj.getClass();
		DTable table = clazz.getAnnotation(DTable.class);
		if(table == null){
			return dataItem;
		}
		Field[] fields = clazz.getDeclaredFields();
    	dataItem = new DataItem();
    	
    	for(Field field : fields) {
    		if(field.isAnnotationPresent(FileUrl.class)) {
    			String key = field.getName();
    			if (!(field.isAccessible())) {
    				field.setAccessible(true);
    			}
    	        Object value = field.get(obj);
    	        if(FileUtils.isLoacl(String.valueOf(value))){
    	        	dataItem.put(key, value);        	        	
    	        }
    		}	
    	}
    	Map<String, Object> data = dataItem.getFields();
    	if(data.size() > 0){
    		Field pkField = clazz.getDeclaredField(table.pk());
    		if (!(pkField.isAccessible())) {
    			pkField.setAccessible(true);
			}
    		dataItem.setTable(table.name());
        	dataItem.setPk(table.pk());
        	dataItem.setId(pkField.get(obj));
        	return dataItem;
    	}
    	return null;
	}
	
}
