package com.crawler.res.utils;

import java.util.ArrayList;
import java.util.List;

public class MimeTypeUtils {

	public static final String TYPE_IMAGE = "IMAGE";
	
	public static final String TYPE_AUDIO = "AUDIO";
	
	public static final String TYPE_VIDEO = "VIDEO";

	public static final String TYPE_UNKNOW = "UNKNOW";
	
	/**
	 * 图片格式
	 */
	public static final List<String> IMAGE_TYPES = new ArrayList<String>(){
		{
			add("jpg");
			add("jpeg");
			add("png");
			add("gif");
		}
	};
	
	/**
	 * 语音格式
	 */
	public static final List<String> AUDIO_TYPES = new ArrayList<String>(){
		{
			add("mp3");
			add("wma");
			add("wav");
			add("amr");
			add("asf");
		}
	};
	
	/**
	 * 视频格式
	 */
	public static final List<String> VIDEO_TYPES = new ArrayList<String>(){
		{
			add("rm");
			add("rmvb");
			add("wmv");
			add("avi");
			add("mpg");
			add("mpeg");
			add("mp4");
		}
	};
	
	
	
	/**
	 * 获取类型
	 * @param ext
	 * @return
	 */
	public static String getMediaType(String ext){
		if(ext!=null){
			ext = ext.toLowerCase();
			if(IMAGE_TYPES.contains(ext)){
				return TYPE_IMAGE;
			}
			else if(AUDIO_TYPES.contains(ext)){
				return TYPE_AUDIO;
			}
			else if(VIDEO_TYPES.contains(ext)){
				return TYPE_VIDEO;
			}
		}
		
		return TYPE_UNKNOW;
	}
}
