/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.rest.security.services.impl;

import com.crawler.rest.config.WafProperties;
import com.crawler.rest.security.authens.UcUserToken;
import com.crawler.rest.security.authentication.bearer.PreAuthenticatedBearerTokenAuthentication;
import com.crawler.rest.security.services.impl.UserCenterBearerTokenService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class UserCenterBearerTokenCacheService
extends UserCenterBearerTokenService {
    private static LoadingCache<String, UcUserToken> bearerTokenCache;
    public static final String BEARER_TOKEN_CACHE_EXPIRE = "bearerToken.cache.expire";
    public static final String BEARER_TOKEN_CACHE_MAX_SIZE = "bearerToken.cache.maxSize";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMacCache() {
        if (bearerTokenCache == null) {
            UserCenterBearerTokenCacheService userCenterBearerTokenCacheService = this;
            synchronized (userCenterBearerTokenCacheService) {
                if (bearerTokenCache == null) {
                    bearerTokenCache = CacheBuilder.newBuilder().maximumSize((long)WafProperties.getPropertyForInteger((String)BEARER_TOKEN_CACHE_MAX_SIZE, (String)"1000")).expireAfterWrite((long)WafProperties.getPropertyForInteger((String)BEARER_TOKEN_CACHE_EXPIRE, (String)"1440"), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, UcUserToken>(){

                        public UcUserToken load(String key) throws Exception {
                            return UserCenterBearerTokenCacheService.this.invoke(key);
                        }
                    });
                }
            }
        }
    }

    private UcUserToken invoke(String bearerToken) {
        return super.verifyToken((Authentication)new PreAuthenticatedBearerTokenAuthentication(bearerToken));
    }

    @Override
    public UcUserToken verifyToken(Authentication preAuthenticatedAuthentication) {
        Assert.notNull((Object)preAuthenticatedAuthentication, (String)"preAuthenticatedAuthentication");
        PreAuthenticatedBearerTokenAuthentication bearerTokenAuthentication = (PreAuthenticatedBearerTokenAuthentication)preAuthenticatedAuthentication;
        this.initMacCache();
        UcUserToken ucCheckToken = null;
        try {
            ucCheckToken = (UcUserToken)bearerTokenCache.get((Object)bearerTokenAuthentication.getBearerToken());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        Assert.notNull((Object)ucCheckToken, (String)"ucCheckToken");
        if (ucCheckToken.getBearerToken().equalsIgnoreCase(bearerTokenAuthentication.getBearerToken())) {
            return ucCheckToken;
        }
        return null;
    }
}

