/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.rest.security.services.impl;

import com.crawler.rest.config.WafProperties;
import com.crawler.rest.security.authens.BaseUserInfo;
import com.crawler.rest.security.authens.UcUserRole;
import com.crawler.rest.security.services.impl.UserCenterUserDetailsService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class UserCenterUserDetailsCacheService
extends UserCenterUserDetailsService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static LoadingCache<String, List<UcUserRole>> userRoleCache;
    private static LoadingCache<String, BaseUserInfo> userInfoCache;
    private final String separator = ":";
    public static final String UC_CACHE_EXPIRE = "uc.cache.expire";
    public static final String UC_CACHE_MAX_SIZE = "uc.cache.maxSize";

    private List<UcUserRole> getUserRoleListInner(String userId) {
        return super.getUserRoleList(userId);
    }

    private BaseUserInfo getUserInfoInner(String userId) {
        return super.getUserInfo(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUserRoleCache() {
        if (userRoleCache == null) {
            UserCenterUserDetailsCacheService userCenterUserDetailsCacheService = this;
            synchronized (userCenterUserDetailsCacheService) {
                if (userRoleCache == null) {
                    userRoleCache = CacheBuilder.newBuilder().maximumSize((long)WafProperties.getPropertyForInteger((String)UC_CACHE_MAX_SIZE, (String)"10000")).expireAfterWrite((long)WafProperties.getPropertyForInteger((String)UC_CACHE_EXPIRE, (String)"20"), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<UcUserRole>>(){

                        public List<UcUserRole> load(String userId) throws Exception {
                            if (!StringUtils.isEmpty((Object)userId)) {
                                return UserCenterUserDetailsCacheService.this.getUserRoleListInner(userId);
                            }
                            throw new IllegalArgumentException("initUserRoleCache \u65b9\u6cd5\u5728\u83b7\u53d6 userId\u7684\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002");
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUserInfoCache() {
        if (userInfoCache == null) {
            UserCenterUserDetailsCacheService userCenterUserDetailsCacheService = this;
            synchronized (userCenterUserDetailsCacheService) {
                if (userInfoCache == null) {
                    userInfoCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, BaseUserInfo>(){

                        public BaseUserInfo load(String userId) throws Exception {
                            if (!StringUtils.isEmpty((Object)userId)) {
                                return UserCenterUserDetailsCacheService.this.getUserInfoInner(userId);
                            }
                            throw new IllegalArgumentException("initUserInfoCache \u65b9\u6cd5\u5728\u83b7\u53d6 userId \u7684\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002");
                        }
                    });
                }
            }
        }
    }

    public List<UcUserRole> getUserRoleList(String userId, String realm) {
        this.initUserRoleCache();
        try {
            return (List)userRoleCache.get((Object)(String.valueOf(userId) + ":" + realm));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public BaseUserInfo getUserInfo(String userId, String realm) {
        this.initUserInfoCache();
        try {
            return (BaseUserInfo)userInfoCache.get((Object)(String.valueOf(userId) + ":" + realm));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

