/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.rest.security.services.impl;

import com.crawler.rest.security.authens.BaseUserInfo;
import com.crawler.rest.security.authens.UcUserRole;
import com.crawler.rest.security.authens.UserCenterUserDetails;
import com.crawler.rest.security.services.RestUserDetailsService;
import com.crawler.rest.uc.service.IRoleService;
import com.crawler.rest.uc.service.IUserService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class UserCenterUserDetailsService
implements RestUserDetailsService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IUserService userService;
    @Resource
    private IRoleService roleService;

    public List<UcUserRole> getUserRoleList(String userId) {
        Assert.notNull((Object)userId, (String)"userId");
        return this.roleService.findRoles(userId);
    }

    public BaseUserInfo getUserInfo(String userId) {
        Assert.notNull((Object)userId, (String)"userId");
        return this.userService.getUserInfo(userId);
    }

    public UserCenterUserDetails loadUserDetailsByUserId(String userId) {
        BaseUserInfo user = this.getUserInfo(userId);
        this.logger.info("user:" + user + ",userId:" + userId);
        List<UcUserRole> roleDetailsCollection = this.getUserRoleList(userId);
        UserCenterUserDetails details = new UserCenterUserDetails(user, roleDetailsCollection);
        return details;
    }
}

