/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.rest.security.services.impl;

import com.crawler.RestProperties;
import com.crawler.client.http.SecurityHttpClient;
import com.crawler.rest.security.authens.BaseUserInfo;
import com.crawler.rest.security.authens.UcUserRole;
import com.crawler.rest.security.authens.UserCenterUserDetails;
import com.crawler.rest.security.services.RestUserDetailsService;
import com.crawler.util.UrlUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class UserCenterUserDetailsService
implements RestUserDetailsService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String UC_GET_USER_INFO = "uc.get.userInfo";
    private static final String UC_GET_USER_ROLES = "uc.get.userRoles";
    protected SecurityHttpClient securityRestApiClient = new SecurityHttpClient();

    String getUserInfoUrl() {
        return UrlUtil.combine((String)RestProperties.getProperty((String)"uc.uri"), (String)RestProperties.getProperty((String)UC_GET_USER_INFO, (String)"user/{user_id}"));
    }

    String getUserRolesUrl() {
        return UrlUtil.combine((String)RestProperties.getProperty((String)"uc.uri"), (String)RestProperties.getProperty((String)UC_GET_USER_ROLES, (String)"user/{user_id}/roles"));
    }

    public List<UcUserRole> getUserRoleList(String userId) {
        Assert.notNull((Object)userId, (String)"userId");
        String userRolesUrl = this.getUserRolesUrl();
        Map resMap = (Map)this.securityRestApiClient.getForObject(userRolesUrl, Map.class, new Object[]{userId});
        if (resMap != null) {
            List lists = (List)resMap.get("items");
            ArrayList<UcUserRole> roles = new ArrayList<UcUserRole>();
            for (LinkedHashMap linkedMap : lists) {
                UcUserRole role = new UcUserRole();
                role.setRoleId(linkedMap.get("role_id").toString());
                role.setRoleName(linkedMap.get("role_name").toString());
                try {
                    String dateString = linkedMap.get("update_time").toString();
                    String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
                    SimpleDateFormat formatDate = new SimpleDateFormat(pattern);
                    role.setUpdateTime(formatDate.parse(dateString));
                }
                catch (ParseException e) {
                    throw new RuntimeException("\u89e3\u6790\u65f6\u95f4\u53d1\u751f\u5f02\u5e38 " + linkedMap.get("update_time").toString(), e);
                }
                roles.add(role);
            }
            return roles;
        }
        return new ArrayList<UcUserRole>();
    }

    public BaseUserInfo getUserInfo(String userId) {
        Assert.notNull((Object)userId, (String)"userId");
        String userInfoUrl = this.getUserInfoUrl();
        return (BaseUserInfo)this.securityRestApiClient.getForObject(userInfoUrl, BaseUserInfo.class, new Object[]{userId});
    }

    public UserCenterUserDetails loadUserDetailsByUserId(String userId) {
        BaseUserInfo user = this.getUserInfo(userId);
        this.logger.info("user:" + user + ",userId:" + userId);
        List<UcUserRole> roleDetailsCollection = this.getUserRoleList(userId);
        UserCenterUserDetails details = new UserCenterUserDetails(user, roleDetailsCollection);
        return details;
    }
}

