/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.hibernate.orm;

import com.crawler.beans.Page;
import com.crawler.utils.BeanUtils;
import com.crawler.utils.ReflectionUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class SimpleHibernateDao<T, PK extends Serializable> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SessionFactory sessionFactory;
    protected Class<T> entityClass;

    public SimpleHibernateDao() {
        this.entityClass = ReflectionUtils.getSuperClassGenricType(this.getClass());
    }

    public SimpleHibernateDao(SessionFactory sessionFactory, Class<T> entityClass) {
        this.sessionFactory = sessionFactory;
        this.entityClass = entityClass;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    public void save(T entity) {
        Assert.notNull(entity, (String)"entity\u4e0d\u80fd\u4e3a\u7a7a");
        this.getSession().saveOrUpdate(entity);
        this.logger.debug("save entity: {}", entity);
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"entity\u4e0d\u80fd\u4e3a\u7a7a");
        this.getSession().delete(entity);
        this.logger.debug("delete entity: {}", entity);
    }

    public void delete(PK id) {
        Assert.notNull(id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        this.delete((PK)this.get(id));
        this.logger.debug("delete entity {},id is {}", (Object)this.entityClass.getSimpleName(), id);
    }

    public T get(PK id) {
        Assert.notNull(id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        return (T)this.getSession().get(this.entityClass, id);
    }

    public List<T> getAll() {
        return this.find(new Criterion[0]);
    }

    public List<T> findBy(String propertyName, Object value) {
        Assert.hasText((String)propertyName, (String)"propertyName\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleExpression criterion = Restrictions.eq((String)propertyName, (Object)value);
        return this.find(new Criterion[]{criterion});
    }

    public T findByUnique(String propertyName, Object value) {
        Assert.hasText((String)propertyName, (String)"propertyName\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleExpression criterion = Restrictions.eq((String)propertyName, (Object)value);
        return (T)this.createCriteria(new Criterion[]{criterion}).uniqueResult();
    }

    public List<T> find(String hql, Object ... values) {
        return this.createQuery(hql, values).list();
    }

    public List<T> find(String hql, Map<String, Object> values) {
        return this.createQuery(hql, values).list();
    }

    public T findUnique(String hql, Object ... values) {
        if (hql.indexOf(" limit ") > 0) {
            String queryString = StringUtils.substringBefore((String)hql, (String)" limit ");
            String[] limit = StringUtils.substringAfter((String)hql, (String)" limit ").trim().split(",");
            Integer first = 0;
            Integer maxResult = 1;
            if (limit.length > 1) {
                first = Integer.parseInt(limit[0].trim());
            }
            return (T)this.createQuery(queryString, values).setFirstResult(first.intValue()).setMaxResults(maxResult.intValue()).uniqueResult();
        }
        return (T)this.createQuery(hql, values).uniqueResult();
    }

    public T findUnique(String hql, Map<String, Object> values) {
        return (T)this.createQuery(hql, values).uniqueResult();
    }

    public Integer findInt(String hql, Object ... values) {
        T result = this.findUnique(hql, values);
        if (result instanceof Long) {
            return ((Long)result).intValue();
        }
        return (Integer)result;
    }

    public Integer findInt(String hql, Map<String, Object> values) {
        T result = this.findUnique(hql, values);
        if (result instanceof Long) {
            return ((Long)result).intValue();
        }
        return (Integer)result;
    }

    public Long findLong(String hql, Object ... values) {
        return (Long)this.findUnique(hql, values);
    }

    public Long findLong(String hql, Map<String, Object> values) {
        return (Long)this.findUnique(hql, values);
    }

    public int batchExecute(String hql, Object ... values) {
        return this.createQuery(hql, values).executeUpdate();
    }

    public int batchExecute(String hql, Map<String, Object> values) {
        return this.createQuery(hql, values).executeUpdate();
    }

    public Query createQuery(String queryString, Object ... values) {
        Assert.hasText((String)queryString, (String)"queryString\u4e0d\u80fd\u4e3a\u7a7a");
        Query query = this.getSession().createQuery(queryString);
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                query.setParameter(i, values[i]);
                ++i;
            }
        }
        return query;
    }

    public Query createQuery(String queryString, Map<String, Object> values) {
        Assert.hasText((String)queryString, (String)"queryString\u4e0d\u80fd\u4e3a\u7a7a");
        Query query = this.getSession().createQuery(queryString);
        if (values != null) {
            query.setProperties(values);
        }
        return query;
    }

    public SQLQuery createSQLQuery(String queryString, Map<String, Object> values) {
        Assert.hasText((String)queryString, (String)"queryString\u4e0d\u80fd\u4e3a\u7a7a");
        SQLQuery query = this.getSession().createSQLQuery(queryString);
        if (values != null) {
            query.setProperties(values);
        }
        return query;
    }

    public SQLQuery createSQLQuery(String queryString, Object ... values) {
        Assert.hasText((String)queryString, (String)"queryString\u4e0d\u80fd\u4e3a\u7a7a");
        SQLQuery query = this.getSession().createSQLQuery(queryString);
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                query.setParameter(i, values[i]);
                ++i;
            }
        }
        return query;
    }

    public List<T> find(Criterion ... criterions) {
        return this.createCriteria(criterions).list();
    }

    public T findUnique(Criterion ... criterions) {
        return (T)this.createCriteria(criterions).uniqueResult();
    }

    public Criteria createCriteria(Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(this.entityClass);
        Criterion[] criterionArray = criterions;
        int n = criterions.length;
        int n2 = 0;
        while (n2 < n) {
            Criterion c = criterionArray[n2];
            criteria.add(c);
            ++n2;
        }
        return criteria;
    }

    public void initObject(Object object) {
        Hibernate.initialize((Object)object);
    }

    public void initObjects(List list) {
        for (Object object : list) {
            Hibernate.initialize(object);
        }
    }

    public <X> List<X> distinct(List<X> list) {
        LinkedHashSet<X> set = new LinkedHashSet<X>(list);
        return new ArrayList<X>(set);
    }

    public String getIdName() {
        ClassMetadata meta = this.getSessionFactory().getClassMetadata(this.entityClass);
        Assert.notNull((Object)meta, (String)("Class " + this.entityClass.getSimpleName() + " not define in HibernateSessionFactory."));
        return meta.getIdentifierPropertyName();
    }

    public void evict(T entity) {
        this.getSession().evict(entity);
    }

    public T refresh(T entity) {
        Assert.notNull(entity);
        this.getSession().refresh(entity);
        return entity;
    }

    public List<T> findAll() {
        return this.findByCriteria(new Criterion[0]);
    }

    public Page<T> findAll(Page<T> page) {
        return this.findByCriteria(page, new Criterion[0]);
    }

    public T load(PK id) {
        return (T)this.getSession().load(this.entityClass, id);
    }

    public List<T> findLimit(int max, String hql, Object[] values) {
        return this.findLimit(this.createQuery(hql, values), max);
    }

    public List<T> findLimit(int max, String hql, Map<String, Object> values) {
        return this.findLimit(this.createQuery(hql, values), max);
    }

    private List<T> findLimit(Query query, int max) {
        if (max > 0) {
            query.setFirstResult(0);
            query.setMaxResults(max);
        }
        return query.list();
    }

    public Page<T> find(Page<T> page, String hql, Object[] values) {
        Query q;
        Assert.notNull(page);
        Map valueMap = null;
        boolean isValueMap = false;
        if (values != null && values.length > 0 && values[0] instanceof Map) {
            valueMap = (Map)values[0];
            isValueMap = true;
        }
        if (page.isAutoCount()) {
            long totalCount = isValueMap ? this.countHqlResult(hql, valueMap) : this.countHqlResult(hql, values);
            page.setTotalCount(totalCount);
        }
        this.resetCaculatePageNo(page);
        Query query = q = isValueMap ? this.createQuery(hql, valueMap) : this.createQuery(hql, values);
        if (page.isFirstSetted()) {
            q.setFirstResult(page.getFirst());
        }
        if (page.isPageSizeSetted()) {
            q.setMaxResults(page.getPageSize());
        }
        page.setItems(q.list());
        return page;
    }

    protected long countSQLResult(String sql, Map<String, Object> values) {
        long count = 0L;
        String fromSql = sql;
        fromSql = "from " + StringUtils.substringAfter((String)fromSql, (String)"from");
        fromSql = StringUtils.substringBefore((String)fromSql, (String)" order by ");
        String countSql = "select count(*) " + fromSql;
        try {
            count = ((BigInteger)this.createSQLQuery(countSql, values).uniqueResult()).longValue();
        }
        catch (Exception e) {
            throw new RuntimeException("SQL can't be auto count, hql is:" + countSql, e);
        }
        return count;
    }

    protected long countHqlResult(String hql, Map<String, Object> values) {
        long count = 0L;
        String fromHql = hql;
        fromHql = "from " + StringUtils.substringAfter((String)fromHql, (String)"from");
        fromHql = StringUtils.substringBefore((String)fromHql, (String)" order by ");
        String countHql = "select count(*) " + fromHql;
        try {
            count = this.findLong(countHql, values);
        }
        catch (Exception e) {
            throw new RuntimeException("hql can't be auto count, hql is:" + countHql, e);
        }
        return count;
    }

    protected long countHqlResult(String hql, Object ... values) {
        long count = 0L;
        String fromHql = hql;
        fromHql = "from " + StringUtils.substringAfter((String)fromHql, (String)"from");
        fromHql = StringUtils.substringBefore((String)fromHql, (String)" order by ");
        String countHql = "select count(*) " + fromHql;
        try {
            count = this.findLong(countHql, values);
        }
        catch (Exception e) {
            throw new RuntimeException("hql can't be auto count, hql is:" + countHql, e);
        }
        return count;
    }

    public List<T> findByCriteria(Criteria criteria) {
        return criteria.list();
    }

    public List<T> findByCriteria(Criterion[] criterion) {
        return this.findByCriteria(this.createCriteria(criterion));
    }

    public List<T> findByCriteria(Order order, Criterion[] criterion) {
        return this.createCriteria(criterion).addOrder(order).list();
    }

    private void resetCaculatePageNo(Page<T> page) {
        if (page.getPageSize() <= 0) {
            return;
        }
        int maxPage = (int)((page.getTotalCount() + (long)page.getPageSize() - 1L) / (long)page.getPageSize());
        if (page.getPageNo() > maxPage) {
            page.setPageNo(Integer.valueOf(maxPage));
        }
    }

    public Page<T> findByCriteria(Page<T> page, Criteria criteria) {
        if (page.hasAlias()) {
            for (Map.Entry entry : page.getAlias().entrySet()) {
                criteria.createAlias((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (page.isAutoCount()) {
            page.setTotalCount((long)this.countQueryResult(criteria));
        }
        if (page.isAutoCount() && page.getTotalCount() < 1L) {
            page.setItems(new ArrayList());
            return page;
        }
        if (page.isFirstSetted()) {
            criteria.setFirstResult(page.getFirst());
        }
        if (page.isPageSizeSetted()) {
            criteria.setMaxResults(page.getPageSize());
        }
        if (page.isOrderBySetted()) {
            this.setOrderBy(criteria, page.getOrderBy());
        }
        page.setItems(criteria.list());
        return page;
    }

    public Page<T> findByCriteria(Page<T> page, Criterion[] criterion) {
        Assert.notNull(page);
        Criteria c = this.createCriteria(criterion);
        return this.findByCriteria(page, c);
    }

    public boolean isPropertyUnique(String propertyName, Object newValue, Object orgValue) {
        if (newValue == null || newValue.equals(orgValue)) {
            return true;
        }
        T object = this.findByUnique(propertyName, newValue);
        return object == null;
    }

    public void setOrderBy(Criteria criteria, String orderBy) {
        if (orderBy != null && !"".equals(orderBy)) {
            String[] orderByArray;
            String[] stringArray = orderByArray = StringUtils.split((String)orderBy, (char)',');
            int n = orderByArray.length;
            int n2 = 0;
            while (n2 < n) {
                String orderStr = stringArray[n2];
                String[] arr = orderStr.split("\\s+");
                if ("asc".equals(arr[1])) {
                    criteria.addOrder(Order.asc((String)arr[0]));
                } else {
                    criteria.addOrder(Order.desc((String)arr[0]));
                }
                ++n2;
            }
        }
    }

    public int countQueryResult(Criteria c) {
        CriteriaImpl impl = (CriteriaImpl)c;
        Projection projection = impl.getProjection();
        ResultTransformer transformer = impl.getResultTransformer();
        List orderEntries = null;
        try {
            orderEntries = (List)BeanUtils.getFieldValue((Object)impl, (String)"orderEntries");
            BeanUtils.setFieldValue((Object)impl, (String)"orderEntries", new ArrayList());
        }
        catch (Exception e) {
            this.logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        int totalCount = Integer.valueOf(c.setProjection(Projections.rowCount()).uniqueResult().toString());
        if (totalCount < 1) {
            totalCount = 0;
        }
        c.setProjection(projection);
        if (projection == null) {
            c.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        }
        if (transformer != null) {
            c.setResultTransformer(transformer);
        }
        try {
            BeanUtils.setFieldValue((Object)impl, (String)"orderEntries", (Object)orderEntries);
        }
        catch (Exception e) {
            this.logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return totalCount;
    }
}

