/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.qq.connect.api;

import com.belerweb.social.API;
import com.belerweb.social.bean.Result;
import com.belerweb.social.qq.connect.api.QQConnect;
import com.belerweb.social.qq.connect.bean.AccessToken;
import com.belerweb.social.qq.connect.bean.Display;
import com.belerweb.social.qq.connect.bean.Gut;
import com.belerweb.social.qq.connect.bean.OpenID;
import com.belerweb.social.qq.connect.bean.Scope;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.json.JSONObject;

public final class OAuth2
extends API {
    OAuth2(QQConnect connect) {
        super(connect);
    }

    public String authorize() {
        return this.authorize(false);
    }

    public String authorize(String redirectUri) {
        return this.authorize(redirectUri, false);
    }

    public String authorize(Boolean wap) {
        return this.authorize(this.connect.getRedirectUri(), wap);
    }

    public String authorize(String redirectUri, Boolean wap) {
        return this.authorize(this.connect.getClientId(), redirectUri, "code", "authorize", Scope.ALL, null, null, wap);
    }

    public String authorize(String clientId, String redirectUri, String responseType, String state, Scope[] scope, Display display, Gut gut, Boolean wap) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.connect.addParameter(params, "response_type", responseType);
        this.connect.addParameter(params, "client_id", clientId);
        this.connect.addParameter(params, "redirect_uri", redirectUri);
        this.connect.addParameter(params, "state", state);
        if (scope != null) {
            this.connect.addParameter(params, "scope", StringUtils.join((Object[])scope, (String)","));
        }
        if (Display.MOBILE.equals((Object)display)) {
            this.connect.addParameter(params, "display", "mobile");
        }
        if (Gut.XHTML.equals((Object)gut)) {
            this.connect.addParameter(params, "g_ut", gut.toString());
        }
        String url = "https://graph.qq.com/oauth2.0/authorize?";
        if (Boolean.TRUE.equals(wap)) {
            url = "https://graph.z.qq.com/moc2/authorize?";
        }
        return url + StringUtils.join(params, (String)"&");
    }

    public Result<AccessToken> accessToken(String code) {
        return this.accessToken(code, this.connect.getRedirectUri());
    }

    public Result<AccessToken> accessToken(String code, String redirectUri) {
        return this.accessToken(code, redirectUri, null);
    }

    public Result<AccessToken> accessToken(String code, Boolean wap) {
        return this.accessToken(code, this.connect.getRedirectUri(), wap);
    }

    public Result<AccessToken> accessToken(String code, String redirectUri, Boolean wap) {
        return this.accessToken(this.connect.getClientId(), this.connect.getClientSecret(), "authorization_code", code, redirectUri, wap);
    }

    public Result<AccessToken> accessToken(String clientId, String clientSecret, String grantType, String code, String redirectUri, Boolean wap) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.connect.addParameter(params, "client_id", clientId);
        this.connect.addParameter(params, "client_secret", clientSecret);
        this.connect.addParameter(params, "grant_type", grantType);
        this.connect.addParameter(params, "code", code);
        this.connect.addParameter(params, "redirect_uri", redirectUri);
        String url = "https://graph.qq.com/oauth2.0/token";
        if (Boolean.TRUE.equals(wap)) {
            url = "https://graph.z.qq.com/moc2/token";
        }
        String result = this.connect.get(url, params).trim();
        return this.parseAccessTokenResult(result);
    }

    public Result<AccessToken> refreshAccessToken(String refreshToken) {
        return this.refreshAccessToken(this.connect.getClientId(), this.connect.getClientSecret(), refreshToken);
    }

    public Result<AccessToken> refreshAccessToken(String clientId, String clientSecret, String refreshToken) {
        return this.refreshAccessToken(clientId, clientSecret, "refresh_token", refreshToken, null);
    }

    public Result<AccessToken> refreshAccessToken(String refreshToken, Boolean wap) {
        return this.refreshAccessToken(this.connect.getClientId(), this.connect.getClientSecret(), refreshToken, wap);
    }

    public Result<AccessToken> refreshAccessToken(String clientId, String clientSecret, String refreshToken, Boolean wap) {
        return this.refreshAccessToken(clientId, clientSecret, "refresh_token", refreshToken, wap);
    }

    public Result<AccessToken> refreshAccessToken(String clientId, String clientSecret, String grantType, String refreshToken, Boolean wap) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.connect.addParameter(params, "client_id", clientId);
        this.connect.addParameter(params, "client_secret", clientSecret);
        this.connect.addParameter(params, "grant_type", grantType);
        this.connect.addParameter(params, "refresh_token", refreshToken);
        String url = "https://graph.qq.com/oauth2.0/token";
        if (Boolean.TRUE.equals(wap)) {
            url = "https://graph.z.qq.com/moc2/token";
        }
        String result = this.connect.get(url, params);
        return this.parseAccessTokenResult(result);
    }

    public Result<OpenID> openId(String accessToken) {
        return this.openId(accessToken, null);
    }

    public Result<OpenID> openId(String accessToken, Boolean wap) {
        JSONObject jsonObject;
        String result;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.connect.addParameter(params, "access_token", accessToken);
        String url = "https://graph.qq.com/oauth2.0/me";
        if (Boolean.TRUE.equals(wap)) {
            url = "https://graph.z.qq.com/moc2/me";
        }
        if ((result = this.connect.get(url, params).trim()).startsWith("callback")) {
            jsonObject = new JSONObject(result.substring(result.indexOf("{"), result.lastIndexOf("}") + 1));
        } else {
            String[] results;
            jsonObject = new JSONObject();
            for (String param : results = result.split("\\&")) {
                String[] keyValue = param.split("\\=");
                jsonObject.put(keyValue[0], keyValue.length > 0 ? keyValue[1] : null);
            }
            String errorCode = jsonObject.optString("code", null);
            if (errorCode != null) {
                jsonObject.put("ret", (Object)errorCode);
            }
        }
        return Result.parse(jsonObject, OpenID.class);
    }

    private Result<AccessToken> parseAccessTokenResult(String result) {
        String[] results;
        if (result.startsWith("callback")) {
            JSONObject jsonObject = new JSONObject(result.substring(result.indexOf("{"), result.lastIndexOf("}") + 1));
            return Result.parse(jsonObject, AccessToken.class);
        }
        JSONObject jsonObject = new JSONObject();
        for (String param : results = result.split("\\&")) {
            String[] keyValue = param.split("\\=");
            jsonObject.put(keyValue[0], keyValue.length > 0 ? keyValue[1] : null);
        }
        String errorCode = jsonObject.optString("code", null);
        if (errorCode != null) {
            jsonObject.put("ret", (Object)errorCode);
        }
        return Result.parse(jsonObject, AccessToken.class);
    }
}

