/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.qq.connect.api;

import com.belerweb.social.API;
import com.belerweb.social.bean.Error;
import com.belerweb.social.bean.Result;
import com.belerweb.social.qq.connect.api.QQConnect;
import com.belerweb.social.qq.connect.bean.FanList;
import com.belerweb.social.qq.connect.bean.IdolList;
import com.belerweb.social.qq.connect.bean.RepostList;
import com.belerweb.social.qq.connect.bean.WeiboUser;
import java.util.ArrayList;
import org.apache.http.NameValuePair;
import org.json.JSONObject;

public final class Weibo
extends API {
    protected Weibo(QQConnect connect) {
        super(connect);
    }

    public Result<WeiboUser> getInfo(String accessToken, String openid) {
        return this.getInfo(this.connect.getClientId(), accessToken, openid);
    }

    public Result<WeiboUser> getInfo(String oAuthConsumerKey, String accessToken, String openid) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.connect.addParameter(params, "oauth_consumer_key", oAuthConsumerKey);
        this.connect.addParameter(params, "access_token", accessToken);
        this.connect.addParameter(params, "openid", openid);
        this.connect.addParameter(params, "format", "json");
        String json = this.connect.get("https://graph.qq.com/user/get_info", params);
        JSONObject jsonObject = new JSONObject(json);
        Error error = Error.parse(jsonObject);
        if (error != null) {
            return new Result<Error>(error);
        }
        return Result.parse(jsonObject.getJSONObject("data"), WeiboUser.class);
    }

    public Result<WeiboUser> getOtherInfo(String accessToken, String openid, String name) {
        return this.getOtherInfo(this.connect.getClientId(), accessToken, openid, name, null);
    }

    public Result<WeiboUser> getOtherInfo(String oAuthConsumerKey, String accessToken, String openid, String name, String fopenid) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.connect.addParameter(params, "oauth_consumer_key", oAuthConsumerKey);
        this.connect.addParameter(params, "access_token", accessToken);
        this.connect.addParameter(params, "openid", openid);
        this.connect.addParameter(params, "format", "json");
        this.connect.addNotNullParameter(params, "name", name);
        this.connect.addNotNullParameter(params, "fopenid", fopenid);
        String json = this.connect.get("https://graph.qq.com/user/get_other_info", params);
        JSONObject jsonObject = new JSONObject(json);
        Error error = Error.parse(jsonObject);
        if (error != null) {
            return new Result<Error>(error);
        }
        return Result.parse(jsonObject.getJSONObject("data"), WeiboUser.class);
    }

    public Result<FanList> getFansList(String accessToken, String openid, int reqNum, int startIndex) {
        return this.getFansList(this.connect.getClientId(), accessToken, openid, reqNum, startIndex, null, null, null);
    }

    public Result<FanList> getFansList(String oAuthConsumerKey, String accessToken, String openid, int reqNum, int startIndex, Boolean newMode, Integer install, Integer sex) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.connect.addParameter(params, "oauth_consumer_key", oAuthConsumerKey);
        this.connect.addParameter(params, "access_token", accessToken);
        this.connect.addParameter(params, "openid", openid);
        this.connect.addParameter(params, "format", "json");
        this.connect.addParameter(params, "reqnum", reqNum);
        this.connect.addParameter(params, "startindex", startIndex);
        if (Boolean.TRUE.equals(newMode)) {
            this.connect.addParameter(params, "mode", "1");
        }
        this.connect.addNotNullParameter(params, "install", install);
        this.connect.addNotNullParameter(params, "sex", sex);
        String json = this.connect.get("https://graph.qq.com/relation/get_fanslist", params);
        JSONObject jsonObject = new JSONObject(json);
        Error error = Error.parse(jsonObject);
        if (error != null) {
            return new Result<Error>(error);
        }
        return Result.parse(jsonObject.getJSONObject("data"), FanList.class);
    }

    public Result<IdolList> getIdolList(String accessToken, String openid, int reqNum, int startIndex) {
        return this.getIdolList(this.connect.getClientId(), accessToken, openid, reqNum, startIndex, null, null);
    }

    public Result<IdolList> getIdolList(String oAuthConsumerKey, String accessToken, String openid, int reqNum, int startIndex, Boolean newMode, Integer install) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.connect.addParameter(params, "oauth_consumer_key", oAuthConsumerKey);
        this.connect.addParameter(params, "access_token", accessToken);
        this.connect.addParameter(params, "openid", openid);
        this.connect.addParameter(params, "format", "json");
        this.connect.addParameter(params, "reqnum", reqNum);
        this.connect.addParameter(params, "startindex", startIndex);
        if (Boolean.TRUE.equals(newMode)) {
            this.connect.addParameter(params, "mode", "1");
        }
        this.connect.addNotNullParameter(params, "install", install);
        String json = this.connect.get("https://graph.qq.com/relation/get_idollist", params);
        JSONObject jsonObject = new JSONObject(json);
        Error error = Error.parse(jsonObject);
        if (error != null) {
            return new Result<Error>(error);
        }
        return Result.parse(jsonObject.getJSONObject("data"), IdolList.class);
    }

    public Result<RepostList> getRepostList(String accessToken, String openid, int flag, String rootId, int pageFlag, int pageTime, int reqNum, String twitterId) {
        return this.getRepostList(this.connect.getClientId(), accessToken, openid, flag, rootId, pageFlag, pageTime, reqNum, twitterId);
    }

    public Result<RepostList> getRepostList(String oAuthConsumerKey, String accessToken, String openid, int flag, String rootId, int pageFlag, int pageTime, int reqNum, String twitterId) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.connect.addParameter(params, "oauth_consumer_key", oAuthConsumerKey);
        this.connect.addParameter(params, "access_token", accessToken);
        this.connect.addParameter(params, "openid", openid);
        this.connect.addParameter(params, "format", "json");
        this.connect.addParameter(params, "flag", flag);
        this.connect.addParameter(params, "rootid", rootId);
        this.connect.addParameter(params, "pageflag", pageFlag);
        this.connect.addParameter(params, "pagetime", pageTime);
        this.connect.addParameter(params, "reqnum", reqNum);
        this.connect.addParameter(params, "twitterid", twitterId);
        String json = this.connect.get("https://graph.qq.com/t/get_repost_list", params);
        JSONObject jsonObject = new JSONObject(json);
        Error error = Error.parse(jsonObject);
        if (error != null) {
            return new Result<Error>(error);
        }
        return Result.parse(jsonObject.getJSONObject("data"), RepostList.class);
    }
}

