/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.weixin.api;

import com.belerweb.social.API;
import com.belerweb.social.bean.Error;
import com.belerweb.social.bean.Result;
import com.belerweb.social.exception.SocialException;
import com.belerweb.social.http.Http;
import com.belerweb.social.weixin.api.Weixin;
import com.belerweb.social.weixin.bean.MediaType;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.json.JSONObject;

public class Media
extends API {
    protected Media(Weixin weixin) {
        super(weixin);
    }

    public Result<com.belerweb.social.weixin.bean.Media> upload(MediaType type, com.belerweb.social.weixin.bean.Media media) {
        return this.upload(this.weixin.getAccessToken().getToken(), type, media);
    }

    public Result<com.belerweb.social.weixin.bean.Media> upload(String accessToken, MediaType type, com.belerweb.social.weixin.bean.Media media) {
        String url = "http://file.api.weixin.qq.com/cgi-bin/media/upload?access_token=" + accessToken + "&type=" + type.value();
        HttpPost request = new HttpPost(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().addBinaryBody("media", media.getContent(), ContentType.create((String)media.getContentType()), media.getName());
        request.setEntity(builder.build());
        try {
            HttpResponse response = Http.CLIENT.execute((HttpUriRequest)request);
            String json = IOUtils.toString((InputStream)response.getEntity().getContent());
            JSONObject jsonObject = new JSONObject(json);
            Error error = Error.parse(jsonObject);
            if (error != null) {
                return new Result<Error>(error);
            }
            media.setId(jsonObject.getString("media_id"));
            return new Result<com.belerweb.social.weixin.bean.Media>(media);
        }
        catch (ClientProtocolException e) {
            throw new SocialException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SocialException(e);
        }
    }

    public Result<com.belerweb.social.weixin.bean.Media> get(String mediaId) {
        return this.get(this.weixin.getAccessToken().getToken(), mediaId);
    }

    public Result<com.belerweb.social.weixin.bean.Media> get(String accessToken, String mediaId) {
        String url = "http://file.api.weixin.qq.com/cgi-bin/media/get?access_token=" + accessToken + "&media_id=" + mediaId;
        try {
            HttpResponse response = Http.CLIENT.execute((HttpUriRequest)new HttpGet(url));
            Header disposition = response.getFirstHeader("Content-disposition");
            HttpEntity entity = response.getEntity();
            if (disposition == null) {
                return new Result<Error>(Error.parse(new JSONObject(IOUtils.toString((InputStream)entity.getContent()))));
            }
            String fileName = disposition.getValue();
            fileName = fileName.substring(fileName.indexOf("\"") + 1, fileName.lastIndexOf("\""));
            com.belerweb.social.weixin.bean.Media media = new com.belerweb.social.weixin.bean.Media();
            media.setId(mediaId);
            media.setName(fileName);
            media.setContentType(entity.getContentType().getValue());
            media.setContent(IOUtils.toByteArray((InputStream)entity.getContent()));
            return new Result<com.belerweb.social.weixin.bean.Media>(media);
        }
        catch (ClientProtocolException e) {
            throw new SocialException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SocialException(e);
        }
    }
}

