/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.social.utils;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipayOpenAuthTokenAppRequest;
import com.alipay.api.request.AlipayUserInfoShareRequest;
import com.alipay.api.response.AlipayOpenAuthTokenAppResponse;
import com.alipay.api.response.AlipayUserInfoShareResponse;
import com.crawler.social.config.AlipayConstant;
import com.crawler.social.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class AlipayUtils {
    public static String getAuthorizeParam() throws UnsupportedEncodingException, AlipayApiException {
        return AlipayUtils.getAuthorizeParam(AlipayConstant.APP_ID, AlipayConstant.PARTNER, AlipayConstant.APP_PRIVATE_KEY);
    }

    public static String getAuthorizeParam(String appId, String partner, String appPrivateKey) throws UnsupportedEncodingException, AlipayApiException {
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put("apiname", "com.alipay.account.auth");
        parameters.put("method", "alipay.open.auth.sdk.code.get");
        parameters.put("app_id", appId);
        parameters.put("app_name", "mc");
        parameters.put("biz_type", "openservice");
        parameters.put("pid", partner);
        parameters.put("product_id", "APP_FAST_LOGIN");
        parameters.put("scope", "kuaijie");
        parameters.put("target_id", StringUtils.uniqueNo("auth"));
        parameters.put("auth_type", "AUTHACCOUNT");
        parameters.put("sign_type", "RSA");
        String paramString = AlipayUtils.toString(parameters);
        paramString = paramString + "&sign=\"" + URLEncoder.encode(AlipaySignature.rsaSign((String)paramString, (String)appPrivateKey, (String)"utf-8"), "utf-8");
        return paramString;
    }

    public static AlipayOpenAuthTokenAppResponse getAccessToken(String appId, String appPrivateKey, String alipayPublicKey, String code) throws AlipayApiException {
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", appId, appPrivateKey, "json", "utf-8", "alipay_public_key", "RSA2");
        AlipayOpenAuthTokenAppRequest request = new AlipayOpenAuthTokenAppRequest();
        request.setBizContent("{\"grant_type\":\"authorization_code\",\"code\":\"" + code + "\"" + "  }");
        return (AlipayOpenAuthTokenAppResponse)alipayClient.execute((AlipayRequest)request);
    }

    public static AlipayOpenAuthTokenAppResponse getAccessToken(String code) throws AlipayApiException {
        return AlipayUtils.getAccessToken(AlipayConstant.APP_ID, AlipayConstant.APP_PRIVATE_KEY, AlipayConstant.ALIPAY_PUBLIC_KEY, code);
    }

    public static AlipayUserInfoShareResponse getUserInfo(String appId, String appPrivateKey, String alipayPublicKey, String accessToken) throws AlipayApiException {
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", appId, appPrivateKey, "json", "utf-8", alipayPublicKey, "RSA2");
        AlipayUserInfoShareRequest request = new AlipayUserInfoShareRequest();
        return (AlipayUserInfoShareResponse)alipayClient.execute((AlipayRequest)request, accessToken);
    }

    public static AlipayUserInfoShareResponse getUserInfo(String accessToken) throws AlipayApiException {
        return AlipayUtils.getUserInfo(AlipayConstant.APP_ID, AlipayConstant.APP_PRIVATE_KEY, AlipayConstant.ALIPAY_PUBLIC_KEY, accessToken);
    }

    private static String toString(SortedMap<String, Object> parameters) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = String.valueOf(entry.getValue());
            if ("sign".equalsIgnoreCase(key) || "key".equalsIgnoreCase(key) || StringUtils.isNullOrEmpty(value)) continue;
            sb.append(key + "=" + value + "&");
        }
        return sb.toString().replaceAll("&$", "");
    }
}

