/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.social.utils;

import com.belerweb.social.bean.Result;
import com.belerweb.social.weibo.api.Weibo;
import com.belerweb.social.weibo.bean.AccessToken;
import com.belerweb.social.weibo.bean.User;
import com.crawler.social.beans.WeiboAccessToken;
import com.crawler.social.beans.WeiboUser;
import com.crawler.social.config.WeiboConstant;
import com.crawler.social.utils.BeanUtils;

public class WeiboUtils {
    public static WeiboAccessToken getAccessToken(String clientId, String clientSecret, String redirectUri, String code) {
        Weibo weibo = new Weibo(clientId, clientSecret, redirectUri);
        return WeiboUtils.getAccessToken(weibo, code);
    }

    public static WeiboAccessToken getAccessToken(String code) {
        return WeiboUtils.getAccessToken(WeiboConstant.CLIENT_ID, WeiboConstant.CLIENT_SECRET, WeiboConstant.REDIRECT_URI, code);
    }

    public static WeiboAccessToken getAccessToken(Weibo weibo, String code) {
        Result<AccessToken> result = weibo.getOAuth2().accessToken(code);
        return BeanUtils.transfer(result.getResult(), WeiboAccessToken.class);
    }

    public static WeiboUser getUserInfo(String clientId, String clientSecret, String redirectUri, String uid) {
        Weibo weibo = new Weibo(clientId, clientSecret, redirectUri);
        return WeiboUtils.getUserInfo(weibo, uid);
    }

    public static WeiboUser getUserInfo(String uid) {
        return WeiboUtils.getUserInfo(WeiboConstant.CLIENT_ID, WeiboConstant.CLIENT_SECRET, WeiboConstant.REDIRECT_URI, uid);
    }

    public static WeiboUser getUserInfo(Weibo weibo, String uid) {
        Result<User> result = weibo.getUser().show(weibo.getClientId(), null, uid, null);
        return BeanUtils.transfer(result.getResult(), WeiboUser.class);
    }
}

