/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.weixin.mini.util;

import com.crawler.redis.utils.RedisManager;
import com.crawler.social.config.SocialProperties;
import com.crawler.utils.http.SimpleHttpClient;
import com.crawler.weixin.mini.util.AES;
import com.crawler.weixin.mini.vo.MiniLoginInfo;
import com.crawler.weixin.mini.vo.MiniSession;
import com.crawler.weixin.mini.vo.MiniUserInfo;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxAppUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(WxAppUtil.class);
    public static final String APP_ID = SocialProperties.getProperty("mini.app_id");
    public static final String APP_SECRET = SocialProperties.getProperty("mini.app_secret");
    public static final String SESSION_URL = "https://api.weixin.qq.com/sns/jscode2session?appid=%s&secret=%s&js_code=%s&grant_type=authorization_code";
    public static final String SESSION_CACHE_KEY_PREFIX = "wx:session:";

    public static MiniSession getSessionByCode(String code) {
        return WxAppUtil.getSessionByCode(APP_ID, APP_SECRET, code);
    }

    public static MiniSession getSessionByCode(String appId, String appSecret, String code) {
        String url = String.format(SESSION_URL, appId, appSecret, code);
        MiniSession session = SimpleHttpClient.getForObject(url, MiniSession.class);
        if (session != null) {
            WxAppUtil.create3rdSession(session);
        }
        return session;
    }

    public static MiniSession getSessionById(String sessionId) {
        String key = WxAppUtil.sessionKey(sessionId);
        return (MiniSession)RedisManager.get((String)key, MiniSession.class);
    }

    public static void create3rdSession(MiniSession session) {
        String sessionId = RandomStringUtils.randomAlphanumeric((int)64);
        if (session != null) {
            session.setSessionId(sessionId);
            String key = WxAppUtil.sessionKey(sessionId);
            RedisManager.set((String)key, (Object)session, (int)session.getExpiresIn());
        }
    }

    public static MiniUserInfo getUserInfo(MiniLoginInfo loginInfo, String sessionKey) {
        return WxAppUtil.getUserInfo(APP_ID, loginInfo, sessionKey);
    }

    public static MiniUserInfo getUserInfo(String appId, MiniLoginInfo loginInfo, String sessionKey) {
        try {
            String userInfo;
            MiniUserInfo userInfoVo;
            AES aes = new AES();
            byte[] resultByte = aes.decrypt(Base64.decodeBase64((String)loginInfo.getEncryptedData()), Base64.decodeBase64((String)sessionKey), Base64.decodeBase64((String)loginInfo.getIv()));
            if (null != resultByte && resultByte.length > 0 && (userInfoVo = (MiniUserInfo)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)(userInfo = new String(resultByte, "UTF-8"))), MiniUserInfo.class)).getWatermark().getAppid().equals(appId)) {
                return userInfoVo;
            }
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private static String sessionKey(String sessionId) {
        return SESSION_CACHE_KEY_PREFIX + sessionId;
    }
}

