/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social;

import com.belerweb.social.bean.Error;
import com.belerweb.social.bean.Result;
import com.belerweb.social.exception.SocialException;
import com.belerweb.social.http.Http;
import com.belerweb.social.http.HttpException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class SDK {
    private final Charset defaultCharset;

    public SDK() {
        this(null);
    }

    public SDK(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public String get(String url, List<NameValuePair> params) {
        try {
            Http.setDefaultCharset(this.defaultCharset);
            return Http.get(url, params);
        }
        catch (HttpException e) {
            throw new SocialException(e);
        }
    }

    public String get(String url) {
        return this.get(url, null);
    }

    public String post(String url, HttpEntity postBody) {
        try {
            Http.setDefaultCharset(this.defaultCharset);
            return Http.post(url, postBody, new Header[0]);
        }
        catch (HttpException e) {
            throw new SocialException(e);
        }
    }

    public String post(String url, List<NameValuePair> params) {
        try {
            Http.setDefaultCharset(this.defaultCharset);
            return Http.post(url, params, "UTF-8", new Header[0]);
        }
        catch (HttpException e) {
            throw new SocialException(e);
        }
    }

    public String post(String url) {
        return this.post(url, (HttpEntity)null);
    }

    public void addParameter(List<NameValuePair> params, String name, Object value) {
        if (value == null) {
            throw new SocialException("Parameter " + name + " must not be null.");
        }
        params.add((NameValuePair)new BasicNameValuePair(name, value.toString()));
    }

    public void addNotNullParameter(List<NameValuePair> params, String name, Object value) {
        if (value != null) {
            params.add((NameValuePair)new BasicNameValuePair(name, value.toString()));
        }
    }

    public void addTrueParameter(List<NameValuePair> params, String name, Boolean value) {
        if (Boolean.TRUE.equals(value)) {
            params.add((NameValuePair)new BasicNameValuePair(name, value.toString()));
        }
    }

    public Result<String> lonLatToAddress(Double lon, Double lat) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addParameter(params, "sensor", "false");
        this.addParameter(params, "language", "zh");
        this.addParameter(params, "latlng", lat + "," + lon);
        String json = this.get("https://maps.googleapis.com/maps/api/geocode/json", params);
        JSONObject jsonObject = new JSONObject(json);
        if (!"OK".equals(jsonObject.getString("status"))) {
            Error error = new Error();
            error.setErrorCode(jsonObject.getString("status"));
            error.setError(jsonObject.optString("error_message"));
            return new Result<Error>(error);
        }
        JSONArray results = jsonObject.getJSONArray("results");
        if (results.length() == 0) {
            return new Result<String>("");
        }
        return new Result<String>(results.getJSONObject(0).getString("formatted_address"));
    }
}

