/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.bean;

import com.belerweb.social.bean.JsonBean;
import com.belerweb.social.bean.Result;
import org.json.JSONObject;

public final class Error
extends JsonBean {
    private String request;
    private String errorCode;
    private String error;

    public Error() {
    }

    public Error(String code, String message) {
        this.errorCode = code;
        this.error = message;
    }

    private Error(JSONObject jsonObject) {
        super(jsonObject);
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String toString() {
        return this.errorCode + ":" + this.error + "(" + this.request + ")";
    }

    public static Error parse(JSONObject jsonObject) {
        String errorCode = jsonObject.optString("error_code", null);
        if (errorCode != null) {
            String request = jsonObject.optString("request", null);
            String error = jsonObject.optString("error", null);
            Error er = new Error(jsonObject);
            er.setRequest(request);
            er.setErrorCode(errorCode);
            er.setError(error);
            return er;
        }
        errorCode = jsonObject.optString("error", null);
        if (errorCode != null) {
            String error = jsonObject.optString("error_description", null);
            Error er = new Error(jsonObject);
            er.setErrorCode(errorCode);
            er.setError(error);
            return er;
        }
        Integer ret = Result.parseInteger(jsonObject.opt("ret"));
        if (ret != null && ret != 0) {
            String msg = jsonObject.optString("msg", null);
            Error er = new Error(jsonObject);
            er.setErrorCode(ret.toString());
            er.setError(msg);
            return er;
        }
        ret = Result.parseInteger(jsonObject.opt("errcode"));
        if (ret != null && ret != 0) {
            String error = jsonObject.optString("errmsg", null);
            Error er = new Error(jsonObject);
            er.setErrorCode(ret.toString());
            er.setError(error);
            return er;
        }
        return null;
    }
}

