/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.weibo.api;

import com.belerweb.social.API;
import com.belerweb.social.bean.Result;
import com.belerweb.social.exception.SocialException;
import com.belerweb.social.weibo.api.Weibo;
import com.belerweb.social.weibo.bean.UserCounts;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;

public final class User
extends API {
    protected User(Weibo weibo) {
        super(weibo);
    }

    public Result<com.belerweb.social.weibo.bean.User> show(String source, String accessToken, String uid, String screenName) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.weibo.addNotNullParameter(params, "source", source);
        this.weibo.addNotNullParameter(params, "access_token", accessToken);
        this.weibo.addNotNullParameter(params, "uid", uid);
        this.weibo.addNotNullParameter(params, "screen_name", screenName);
        String json = this.weibo.get("https://api.weibo.com/2/users/show.json", params);
        return Result.parse(json, com.belerweb.social.weibo.bean.User.class);
    }

    public Result<com.belerweb.social.weibo.bean.User> domainShow(String source, String accessToken, String domain) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.weibo.addNotNullParameter(params, "source", source);
        this.weibo.addNotNullParameter(params, "access_token", accessToken);
        this.weibo.addParameter(params, "domain", domain);
        String json = this.weibo.get("https://api.weibo.com/2/users/domain_show.json", params);
        return Result.parse(json, com.belerweb.social.weibo.bean.User.class);
    }

    public Result<UserCounts> counts(String source, String accessToken, List<String> uids) {
        if (uids == null || uids.size() > 100) {
            throw new SocialException("\u9700\u8981\u83b7\u53d6\u6570\u636e\u7684\u7528\u6237UID\uff0c\u5fc5\u987b\u4e14\u6700\u591a\u4e0d\u8d85\u8fc7100\u4e2a");
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.weibo.addNotNullParameter(params, "source", source);
        this.weibo.addNotNullParameter(params, "access_token", accessToken);
        this.weibo.addParameter(params, "uids", StringUtils.join(uids, (String)","));
        String result = this.weibo.get("https://api.weibo.com/2/users/counts.json", params);
        return Result.parse(result, UserCounts.class);
    }
}

