/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.weixin.utils;

import com.crawler.redis.utils.RedisManager;
import com.crawler.social.config.SocialProperties;
import com.crawler.social.config.WeixinConstant;
import com.crawler.social.utils.BeanUtils;
import com.crawler.utils.http.SimpleHttpClient;
import com.crawler.weixin.common.StringUtils;
import com.crawler.weixin.enums.QrcodeActionName;
import com.crawler.weixin.model.Menu;
import com.crawler.weixin.vo.AccessToken;
import com.crawler.weixin.vo.FansUserInfo;
import com.crawler.weixin.vo.QrcodeResponse;
import com.crawler.weixin.vo.Ticket;
import com.crawler.weixin.vo.WeixinAccessToken;
import com.crawler.weixin.vo.WeixinUser;
import com.crawler.weixin.vo.WxJsConfig;
import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeixinUtils {
    private static final Logger logger = LoggerFactory.getLogger(WeixinUtils.class);
    private static final String WEIXIN_CACHE_PREFIX = SocialProperties.getProperty("app.id", "social") + ":weixin";
    private static final String ACCESS_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
    private static final String TICKET_URL = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=jsapi";
    private static final String USER_ACCESS_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code";
    private static final String USERINFO_URL = "https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s&lang=zh_CN";
    private static final String AUTHORIZE_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_userinfo&state=1#wechat_redirect";
    private static final String FANS_USER_INFO_URL = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=%s&openid=%s&lang=zh_CN";
    private static final String CREATE_QRCODE = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=%s";
    private static final String CREATE_MENU = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=%s";

    public static WeixinAccessToken getUserAccessToken(String appId, String appSecret, String code) {
        String url = String.format(USER_ACCESS_TOKEN_URL, appId, appSecret, code);
        return SimpleHttpClient.getForObject(url, WeixinAccessToken.class);
    }

    public static WeixinAccessToken getUserAccessToken(String code) {
        String url = String.format(USER_ACCESS_TOKEN_URL, WeixinConstant.APP_ID, WeixinConstant.APP_SECRET, code);
        return SimpleHttpClient.getForObject(url, WeixinAccessToken.class);
    }

    public static WeixinUser getUserInfo(String accessToken, String openid) {
        String url = String.format(USERINFO_URL, accessToken, openid);
        return SimpleHttpClient.getForObject(url, WeixinUser.class);
    }

    public static AccessToken getAccessToken(String appId, String appSecret) {
        String key = WeixinUtils.accessTokenKey(appId);
        AccessToken accessToken = (AccessToken)RedisManager.get((String)key, AccessToken.class);
        logger.info("AccessToken\uff1a{}", (Object)BeanUtils.toJSONString(accessToken));
        if (accessToken == null) {
            String url = String.format(ACCESS_TOKEN_URL, appId, appSecret);
            accessToken = SimpleHttpClient.getForObject(url, AccessToken.class);
            accessToken.setExpireAt(new Date(System.currentTimeMillis() + (long)(accessToken.getExpiresIn() * 1000)));
            RedisManager.set((String)key, (Object)accessToken, (int)accessToken.getExpiresIn());
            logger.info("\u65b0\u83b7\u53d6\u5230AccessToken\uff1a{}", (Object)BeanUtils.toJSONString(accessToken));
        }
        return accessToken;
    }

    public static Ticket getTicket(String accessToken) {
        String key = WeixinUtils.ticketKey(accessToken);
        Ticket ticket = (Ticket)RedisManager.get((String)key, Ticket.class);
        if (ticket == null) {
            String url = String.format(TICKET_URL, accessToken);
            ticket = SimpleHttpClient.getForObject(url, Ticket.class);
            ticket.setExpireAt(new Date(System.currentTimeMillis() + (long)(ticket.getExpiresIn() * 1000)));
            RedisManager.set((String)key, (Object)ticket, (int)ticket.getExpiresIn());
        }
        return ticket;
    }

    public static WxJsConfig signature(String url) {
        return WeixinUtils.signature(WeixinConstant.APP_ID, WeixinConstant.APP_SECRET, url);
    }

    public static WxJsConfig signature(String appId, String secret, String url) {
        WxJsConfig wxJsConfig = new WxJsConfig();
        wxJsConfig.setAppId(appId);
        wxJsConfig.setNonceStr(StringUtils.getRandomString(16));
        wxJsConfig.setTimestamp(System.currentTimeMillis() / 1000L);
        AccessToken accessToken = WeixinUtils.getAccessToken(appId, secret);
        Ticket ticket = WeixinUtils.getTicket(accessToken.getAccessToken());
        String str = String.format("jsapi_ticket=%s&noncestr=%s&timestamp=%s&url=%s", ticket.getTicket(), wxJsConfig.getNonceStr(), wxJsConfig.getTimestamp(), url);
        String signature = DigestUtils.shaHex((byte[])str.getBytes());
        wxJsConfig.setSignature(signature);
        return wxJsConfig;
    }

    public static void authorize(HttpServletResponse response, String redirectUrl) throws IOException {
        WeixinUtils.authorize(response, WeixinConstant.APP_ID, redirectUrl);
    }

    public static void authorize(HttpServletResponse response, String appId, String redirectUrl) throws IOException {
        String location = String.format(AUTHORIZE_URL, appId, redirectUrl);
        response.sendRedirect(location);
    }

    public static FansUserInfo getFansUserInfo(String accessToken, String openid) {
        String url = String.format(FANS_USER_INFO_URL, accessToken, openid);
        return SimpleHttpClient.getForObject(url, FansUserInfo.class);
    }

    public static FansUserInfo getFansUserInfo(String openid) {
        return WeixinUtils.getFansUserInfo(WeixinConstant.APP_ID, WeixinConstant.APP_SECRET, openid);
    }

    public static FansUserInfo getFansUserInfo(String appId, String appSecret, String openid) {
        AccessToken accessToken = WeixinUtils.getAccessToken(appId, appSecret);
        return WeixinUtils.getFansUserInfo(accessToken.getAccessToken(), openid);
    }

    public static QrcodeResponse createQrcode(QrcodeActionName actionName, String sceneId, Integer expireSeconds) {
        return WeixinUtils.createQrcode(WeixinConstant.APP_ID, WeixinConstant.APP_SECRET, actionName, sceneId, expireSeconds);
    }

    public static QrcodeResponse createQrcode(String appId, String appSecret, QrcodeActionName actionName, String sceneId, Integer expireSeconds) {
        AccessToken accessToken = WeixinUtils.getAccessToken(appId, appSecret);
        return WeixinUtils.createQrcode(accessToken, actionName, sceneId, expireSeconds);
    }

    public static QrcodeResponse createQrcode(AccessToken accessToken, QrcodeActionName actionName, String sceneId, Integer expireSeconds) {
        JSONObject scene = new JSONObject();
        if (StringUtils.isNumeric(sceneId)) {
            scene.put((Object)"scene_id", (Object)Long.parseLong(sceneId));
        } else {
            scene.put((Object)"scene_str", (Object)sceneId);
        }
        JSONObject body = new JSONObject();
        JSONObject actionInfo = new JSONObject();
        actionInfo.put((Object)"scene", (Object)scene);
        body.put((Object)"action_name", (Object)actionName);
        if ((actionName.equals((Object)QrcodeActionName.QR_SCENE) || actionName.equals((Object)QrcodeActionName.QR_STR_SCENE)) && expireSeconds != null) {
            body.put((Object)"expire_seconds", (Object)expireSeconds);
        }
        body.put((Object)"action_info", (Object)actionInfo);
        String url = String.format(CREATE_QRCODE, accessToken.getAccessToken());
        return SimpleHttpClient.postForObject(url, body, QrcodeResponse.class);
    }

    public static boolean createMenu(Menu menu) {
        return WeixinUtils.createMenu(menu, WeixinConstant.WECHAT_APP_ID, WeixinConstant.WECHAT_APP_SECRET);
    }

    public static boolean createMenu(Menu menu, String appId, String appSecret) {
        JSONObject response;
        AccessToken accessToken = WeixinUtils.getAccessToken(appId, appSecret);
        String url = String.format(CREATE_MENU, accessToken.getAccessToken());
        String content = SimpleHttpClient.post(url, JSONObject.fromObject((Object)BeanUtils.toJSONString(menu)));
        logger.info("\u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)content);
        return content.startsWith("{") && content.endsWith("}") && (response = JSONObject.fromObject((Object)content)).getInt("errcode") == 0;
    }

    private static String accessTokenKey(String appId) {
        return String.format("%s:%s:%s", WEIXIN_CACHE_PREFIX, "access_token", appId);
    }

    private static String ticketKey(String accessToken) {
        return String.format("%s:%s:%s", WEIXIN_CACHE_PREFIX, "ticket", accessToken);
    }
}

