package com.crawler.social.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.request.AlipayUserInfoShareRequest;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.alipay.api.response.AlipayUserInfoShareResponse;
import com.crawler.social.config.AlipayConstant;


/**
 * 支付宝工具类
 * @author rubekid
 *
 * 2017年10月16日 下午6:41:23
 */
public class AlipayUtils {

	/**
	 * 获取授权参数
	 * @return
	 * @throws UnsupportedEncodingException
	 * @throws AlipayApiException
	 */
	public static String getAuthorizeParam() throws UnsupportedEncodingException, AlipayApiException{
		return getAuthorizeParam(AlipayConstant.APP_ID, AlipayConstant.PARTNER, AlipayConstant.APP_PRIVATE_KEY);
	}
	
	/**
	 * 获取授权参数
	 * @param appId
	 * @param partner
	 * @param appPrivateKey
	 * @return
	 * @throws UnsupportedEncodingException
	 * @throws AlipayApiException
	 */
	public static String getAuthorizeParam(String appId, String partner, String appPrivateKey) throws UnsupportedEncodingException, AlipayApiException{
		SortedMap<String,Object> parameters = new TreeMap<String, Object>();
		parameters.put("apiname", "com.alipay.account.auth");
		parameters.put("method", "alipay.open.auth.sdk.code.get");
		parameters.put("app_id", appId);
		parameters.put("app_name", "mc");
		parameters.put("biz_type", "openservice");
		parameters.put("pid", partner);
		parameters.put("product_id", "APP_FAST_LOGIN");
		parameters.put("scope", "kuaijie");
		parameters.put("target_id", StringUtils.uniqueNo("auth"));
		parameters.put("auth_type", "AUTHACCOUNT");
		parameters.put("sign_type", "RSA2");
		String paramString = toString(parameters);
		paramString =  (paramString + "&sign=\""
		+ URLEncoder.encode(AlipaySignature.rsaSign(paramString, appPrivateKey, AlipayConstant.CHARSET), AlipayConstant.CHARSET));
		
		return paramString;
	}
	
	/**
	 * 获取授权信息
	 * @param appId
	 * @param appPrivateKey
	 * @param alipayPublicKey
	 * @param code
	 * @return
	 * @throws AlipayApiException
	 */
	public static AlipaySystemOauthTokenResponse getAccessToken(String appId, String appPrivateKey, String alipayPublicKey, String code) throws AlipayApiException{
		AlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", appId, appPrivateKey, "json", "utf-8", alipayPublicKey, "RSA2");
		AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
		request.setGrantType("authorization_code");
		request.setCode(code);
		return  alipayClient.execute(request);
	}
	
	/**
	 * 获取授权信息
	 * @param code
	 * @return
	 * @throws AlipayApiException
	 */
	public static AlipaySystemOauthTokenResponse getAccessToken(String code) throws AlipayApiException{
		return getAccessToken(AlipayConstant.APP_ID, AlipayConstant.APP_PRIVATE_KEY, AlipayConstant.ALIPAY_PUBLIC_KEY, code);
	}
	
	/**
	 * 获取授权用户信息
	 * @param appId
	 * @param appPrivateKey
	 * @param alipayPublicKey
	 * @param accessToken
	 * @return
	 * @throws AlipayApiException
	 */
	public static AlipayUserInfoShareResponse getUserInfo(String appId, String appPrivateKey, String alipayPublicKey, String accessToken) throws AlipayApiException{
		AlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", appId, appPrivateKey,"json","utf-8", alipayPublicKey, "RSA2");
		AlipayUserInfoShareRequest request = new AlipayUserInfoShareRequest();
		return  alipayClient.execute(request,accessToken);
	}
	
	/**
	 * 获取授权用户信息
	 * @param accessToken
	 * @return
	 * @throws AlipayApiException
	 */
	public static AlipayUserInfoShareResponse getUserInfo(String accessToken) throws AlipayApiException{
		return getUserInfo(AlipayConstant.APP_ID, AlipayConstant.APP_PRIVATE_KEY, AlipayConstant.ALIPAY_PUBLIC_KEY, accessToken);
	}
	
	/**
	 * 参数转字符串连接
	 * @param parameters
	 * @return
	 */
	private static String toString(SortedMap<String, Object> parameters){
		StringBuffer sb = new StringBuffer();
		for (Map.Entry<String, Object> entry : parameters.entrySet()) {
			String key = entry.getKey();
			String value = String.valueOf(entry.getValue());
			if (!"sign".equalsIgnoreCase(key) && !"key".equalsIgnoreCase(key) && !StringUtils.isNullOrEmpty(value)) {
				sb.append(key + "=" + value + "&");
			}
		}
		return sb.toString().replaceAll("&$", "");
	}
	
	
}
